/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation;

import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.rotation.AbstractRotationSimulationPanel;
import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.model.RotationModel;
import javax.swing.JFrame;

public abstract class AbstractRotationModule
extends PiccoloModule {
    private AbstractRotationSimulationPanel rotationSimulationPanel;
    private RotationModel rotationModel;
    private VectorViewModel vectorViewModel;

    public AbstractRotationModule(JFrame jFrame) {
        super("Rotation", new ConstantDtClock(30, 0.03));
        this.setModel(new BaseModel());
        this.setLogoPanel(null);
        this.setClockControlPanel(null);
        this.rotationModel = this.createModel((ConstantDtClock)this.getClock());
        this.vectorViewModel = new VectorViewModel();
        this.rotationSimulationPanel = this.createSimulationPanel(jFrame);
        this.setSimulationPanel(this.rotationSimulationPanel);
    }

    protected abstract RotationModel createModel(ConstantDtClock var1);

    protected abstract AbstractRotationSimulationPanel createSimulationPanel(JFrame var1);

    public RotationModel getRotationModel() {
        return this.rotationModel;
    }

    public AbstractRotationSimulationPanel getRotationSimulationPanel() {
        return this.rotationSimulationPanel;
    }

    public void startApplication() {
        this.rotationSimulationPanel.startApplication();
    }

    public void resetAll() {
        this.rotationModel.resetAll();
        this.rotationSimulationPanel.resetAll();
        this.vectorViewModel.resetAll();
        if (this.getClock() instanceof ConstantDtClock) {
            ConstantDtClock constantDtClock = (ConstantDtClock)this.getClock();
            constantDtClock.setDt(0.03);
        }
        DefaultTimeSeries.verifySeriesCleared();
    }

    public VectorViewModel getVectorViewModel() {
        return this.vectorViewModel;
    }
}

