/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation;

import edu.colorado.phet.common.motion.graphs.GraphSetModel;
import edu.colorado.phet.common.motion.graphs.GraphSuiteSet;
import edu.colorado.phet.common.motion.graphs.MinimizableControlGraph;
import edu.colorado.phet.common.motion.graphs.TimeSeriesGraphSetNode;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.piccolophet.BufferedPhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.PDebugKeyHandler;
import edu.colorado.phet.common.piccolophet.nodes.RulerNode;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.rotation.AbstractRotationModule;
import edu.colorado.phet.rotation.AngleUnitModel;
import edu.colorado.phet.rotation.RotationLayout;
import edu.colorado.phet.rotation.graphs.RotationGraphSet;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.view.RotationLookAndFeel;
import edu.colorado.phet.rotation.view.RotationPlayAreaNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;

public abstract class AbstractRotationSimulationPanel
extends BufferedPhetPCanvas {
    private AbstractRotationModule rotationModule;
    private RotationPlayAreaNode rotationPlayAreaNode;
    private TimeSeriesGraphSetNode timeSeriesGraphSetNode;
    private PSwing rotationControlPanelNode;
    private GraphSuiteSet rotationGraphSet;
    private GraphSetModel graphSetModel;
    private AngleUnitModel angleUnitModel = new AngleUnitModel(false);
    private boolean synchronousPaint = true;

    public AbstractRotationSimulationPanel(final AbstractRotationModule abstractRotationModule, JFrame jFrame) {
        this.rotationModule = abstractRotationModule;
        this.setBackground(new RotationLookAndFeel().getBackgroundColor());
        this.rotationGraphSet = this.createRotationGraphSet();
        this.graphSetModel = new GraphSetModel(this.rotationGraphSet.getGraphSuite(0));
        this.rotationPlayAreaNode = this.createPlayAreaNode();
        final TimeSeriesModel timeSeriesModel = abstractRotationModule.getRotationModel().getTimeSeriesModel();
        timeSeriesModel.addListener(new TimeSeriesModel.Adapter(){

            public void dataSeriesChanged() {
                if (timeSeriesModel.numPlaybackStates() == 0) {
                    abstractRotationModule.getRotationModel().clear();
                    AbstractRotationSimulationPanel.this.rotationGraphSet.clear();
                }
            }
        });
        this.timeSeriesGraphSetNode = new TimeSeriesGraphSetNode(this.graphSetModel, timeSeriesModel, 0.0075, 0.03);
        this.rotationControlPanelNode = new PSwing(this.createControlPanel(this.getRulerNode(), jFrame));
        this.addScreenChild(this.rotationControlPanelNode);
        this.addScreenChild(this.timeSeriesGraphSetNode);
        this.addScreenChild(this.rotationPlayAreaNode);
        this.relayout();
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                AbstractRotationSimulationPanel.this.relayout();
                AbstractRotationSimulationPanel.this.timeSeriesGraphSetNode.forceRepaintGraphs();
            }

            public void componentShown(ComponentEvent componentEvent) {
            }
        });
        this.addKeyListener(new PDebugKeyHandler());
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 116 && keyEvent.isAltDown()) {
                    AbstractRotationSimulationPanel.this.relayout();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 70) {
                    AbstractRotationSimulationPanel.this.setFlowLayout();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 65) {
                    AbstractRotationSimulationPanel.this.setAlignedLayout();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                AbstractRotationSimulationPanel.this.requestFocus();
            }
        });
        this.setAlignedLayout();
        abstractRotationModule.getClock().addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                if (AbstractRotationSimulationPanel.this.synchronousPaint) {
                    AbstractRotationSimulationPanel.this.paintImmediately(0, 0, AbstractRotationSimulationPanel.this.getWidth(), AbstractRotationSimulationPanel.this.getHeight());
                }
            }
        });
        this.angleUnitModel.addListener(new AngleUnitModel.Listener(){

            public void changed() {
                AbstractRotationSimulationPanel.this.timeSeriesGraphSetNode.forceRelayout();
            }
        });
    }

    public boolean isSynchronousPaint() {
        return this.synchronousPaint;
    }

    public void setSynchronousPaint(boolean bl) {
        this.synchronousPaint = bl;
    }

    public void resetAll() {
        this.rotationGraphSet.resetAll();
        this.graphSetModel.setGraphSuite(this.rotationGraphSet.getGraphSuite(0));
        this.rotationPlayAreaNode.resetAll();
    }

    protected GraphSuiteSet createRotationGraphSet() {
        return new RotationGraphSet(this, this.rotationModule.getRotationModel(), this.getAngleUnitModel());
    }

    public GraphSuiteSet getRotationGraphSet() {
        return this.rotationGraphSet;
    }

    protected abstract JComponent createControlPanel(RulerNode var1, JFrame var2);

    protected abstract RotationPlayAreaNode createPlayAreaNode();

    private void setAlignedLayout() {
        this.timeSeriesGraphSetNode.setAlignedLayout();
    }

    private void setFlowLayout() {
        this.timeSeriesGraphSetNode.setFlowLayout();
    }

    private void relayout() {
        new RotationLayout(this, this.rotationPlayAreaNode, this.rotationControlPanelNode, this.timeSeriesGraphSetNode, this.rotationPlayAreaNode.getPlatformNode(), this.rotationPlayAreaNode.getOriginNode()).layout();
    }

    public GraphSetModel getGraphSetModel() {
        return this.graphSetModel;
    }

    public AbstractRotationModule getAbstractRotationModule() {
        return this.rotationModule;
    }

    public RotationModel getRotationModel() {
        return this.rotationModule.getRotationModel();
    }

    public RulerNode getRulerNode() {
        return this.rotationPlayAreaNode.getRulerNode();
    }

    public void startApplication() {
        this.timeSeriesGraphSetNode.forceRelayout();
        this.timeSeriesGraphSetNode.forceRepaintGraphs();
    }

    public void setGraphsBufferedImmediateSeries() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.rotationGraphSet.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            minimizableControlGraphArray[i].getControlGraph().getDynamicJFreeChartNode().setBufferedImmediateSeries();
        }
    }

    public void setGraphsBufferedSeries() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.rotationGraphSet.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            minimizableControlGraphArray[i].getControlGraph().getDynamicJFreeChartNode().setBufferedSeries();
        }
    }

    public void setGraphsPiccoloSeries() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.rotationGraphSet.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            minimizableControlGraphArray[i].getControlGraph().getDynamicJFreeChartNode().setPiccoloSeries();
        }
    }

    public RotationPlayAreaNode getRotationPlayAreaNode() {
        return this.rotationPlayAreaNode;
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this.rotationModule == null || this.rotationModule.getClock() == null || !this.rotationModule.getClock().isRunning() || !this.synchronousPaint) {
            super.repaint(l, n, n2, n3, n4);
        }
    }

    public AngleUnitModel getAngleUnitModel() {
        return this.angleUnitModel;
    }
}

