/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.util.QuickProfiler;
import edu.colorado.phet.rotation.RotationDevMenu;
import edu.colorado.phet.rotation.RotationModule;
import edu.colorado.phet.rotation.RotationResources;
import edu.colorado.phet.rotation.RotationTestMenu;
import edu.colorado.phet.rotation.torque.RotationFrameSetup;
import edu.colorado.phet.rotation.view.RotationLookAndFeel;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class RotationApplication
extends PhetApplication {
    private RotationModule rotationModule = new RotationModule(this.getPhetFrame());

    public RotationApplication(String[] stringArray) {
        super(new PhetApplicationConfig(stringArray, new RotationFrameSetup(), RotationResources.getInstance()));
        this.addModule(this.rotationModule);
        this.getPhetFrame().addMenu(new RotationTestMenu());
        this.getPhetFrame().addMenu(new RotationDevMenu(this));
        this.getPhetFrame().addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                System.out.println("RotationApplication.windowGainedFocus");
                if (RotationApplication.this.getPhetFrame().getContentPane() instanceof JComponent) {
                    JComponent jComponent = (JComponent)RotationApplication.this.getPhetFrame().getContentPane();
                    jComponent.paintImmediately(0, 0, jComponent.getWidth(), jComponent.getHeight());
                }
            }

            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
    }

    public void startApplication() {
        super.startApplication();
        this.rotationModule.getRotationSimulationPanel().requestFocus();
        this.rotationModule.startApplication();
    }

    public static void main(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                QuickProfiler quickProfiler = new QuickProfiler();
                new RotationLookAndFeel().initLookAndFeel();
                new RotationApplication(stringArray).startApplication();
                System.out.println("appStartTime = " + quickProfiler);
            }
        });
    }

    public RotationModule getRotationModule() {
        return this.rotationModule;
    }
}

