/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation;

import edu.colorado.phet.rotation.view.RotationPlatformNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class RotationLayout {
    private JComponent parent;
    private PNode rotationPlayAreaNode;
    private PNode rotationControlPanelNode;
    private PNode timeSeriesGraphSetNode;
    private RotationPlatformNode platformNode;
    private PNode originNode;
    private double playAreaPadY = 50.0;

    public RotationLayout(JComponent jComponent, PNode pNode, PNode pNode2, PNode pNode3, RotationPlatformNode rotationPlatformNode, PNode pNode4) {
        this.parent = jComponent;
        this.rotationPlayAreaNode = pNode;
        this.rotationControlPanelNode = pNode2;
        this.timeSeriesGraphSetNode = pNode3;
        this.platformNode = rotationPlatformNode;
        this.originNode = pNode4;
    }

    public void layout() {
        int n = 10;
        int n2 = 10;
        this.rotationControlPanelNode.setOffset(0.0, this.getHeight() - this.rotationControlPanelNode.getFullBounds().getHeight());
        double d = this.rotationControlPanelNode.getFullBounds().getWidth();
        double d2 = this.getHeight() - this.rotationControlPanelNode.getFullBounds().getHeight();
        d = Math.max((double)Toolkit.getDefaultToolkit().getScreenSize().width * 0.3333333333333333, d);
        this.rotationPlayAreaNode.setScale(1.0);
        double d3 = (d -= (double)(n * 2)) / this.platformNode.getFullBounds().getWidth();
        double d4 = (d2 -= (double)(n2 * 2)) / this.platformNode.getFullBounds().getHeight();
        double d5 = Math.min(d3, d4);
        if (d5 > 0.0) {
            this.rotationPlayAreaNode.scale(d5);
        }
        this.rotationPlayAreaNode.setOffset(d5 * this.platformNode.getRotationPlatform().getRadius(), d5 * this.platformNode.getRotationPlatform().getRadius());
        double d6 = this.originNode.getGlobalFullBounds().getWidth();
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.getMaxXPlayAreaAndControlPanel() + (double)n + d6, 0.0, this.getWidth() - this.getMaxXPlayAreaAndControlPanel() - (double)n - d6, this.getHeight());
        this.timeSeriesGraphSetNode.setBounds(double_);
    }

    private double getMaxXPlayAreaAndControlPanel() {
        return Math.max(this.platformNode.getGlobalFullBounds().getMaxX(), this.platformNode.getGlobalFullBounds().getMaxX());
    }

    private double getWidth() {
        return this.parent.getWidth();
    }

    private double getHeight() {
        return this.parent.getHeight();
    }
}

