/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.controls;

import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.view.RotationLookAndFeel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShowVectorsControl
extends JPanel {
    private VectorViewModel vectorViewModel;

    public ShowVectorsControl(final VectorViewModel vectorViewModel) {
        this.vectorViewModel = vectorViewModel;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        final JCheckBox jCheckBox = new JCheckBox("velocity", vectorViewModel.isVelocityVisible());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                vectorViewModel.setVelocityVisible(jCheckBox.isSelected());
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("acceleration", vectorViewModel.isAccelerationVisible());
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                vectorViewModel.setAccelerationVisible(jCheckBox2.isSelected());
            }
        });
        vectorViewModel.addListener(new VectorViewModel.Listener(){

            public void visibilityChanged() {
                jCheckBox.setSelected(vectorViewModel.isVelocityVisible());
                jCheckBox2.setSelected(vectorViewModel.isAccelerationVisible());
            }
        });
        JLabel jLabel = new JLabel("Show Vectors:");
        jLabel.setFont(RotationLookAndFeel.getControlPanelTitleFont());
        jCheckBox.setFont(RotationLookAndFeel.getCheckBoxFont());
        jCheckBox2.setFont(RotationLookAndFeel.getCheckBoxFont());
        this.add((Component)jLabel, gridBagConstraints);
        this.add((Component)jCheckBox, gridBagConstraints);
        this.add((Component)jCheckBox2, gridBagConstraints);
    }
}

