/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.graphs;

import edu.colorado.phet.common.motion.graphs.ControlGraph;
import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.MotionControlGraph;
import edu.colorado.phet.common.motion.graphs.ReadoutTitleNode;
import edu.colorado.phet.common.motion.model.ISimulationVariable;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.phetcommon.view.util.PhetDefaultFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.timeseries.model.TimeSeriesModel;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.view.RotationLookAndFeel;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.ui.RectangleEdge;

public class RotationGraph
extends MotionControlGraph {
    private ArrayList secondarySeries = new ArrayList();
    private ArrayList seriesPairs = new ArrayList();
    private RotationGraphNumberAxis verticalAxis;
    private String title;

    public RotationGraph(PhetPCanvas phetPCanvas, ISimulationVariable iSimulationVariable, String string, String string2, String string3, double d, double d2, PImage pImage, RotationModel rotationModel, boolean bl, TimeSeriesModel timeSeriesModel, UpdateStrategy updateStrategy, double d3, RotationPlatform rotationPlatform) {
        super(phetPCanvas, iSimulationVariable, string, string2, d, d2, pImage, rotationModel, bl, timeSeriesModel, updateStrategy, d3, rotationPlatform);
        this.title = string2;
        super.getDynamicJFreeChartNode().setAutoUpdateAll(false);
        this.verticalAxis = new RotationGraphNumberAxis(string2 + " (" + string3 + ")");
        this.verticalAxis.setRange(this.getJFreeChartNode().getChart().getXYPlot().getRangeAxis().getRange());
        this.getJFreeChartNode().getChart().getXYPlot().setRangeAxis(this.verticalAxis);
        NumberAxis numberAxis = new NumberAxis("time (s)");
        numberAxis.setLabelFont(new PhetDefaultFont(12));
        numberAxis.setRange(this.getJFreeChartNode().getChart().getXYPlot().getDomainAxis().getRange());
        numberAxis.setTickUnit(new NumberTickUnit(2.5));
        this.getJFreeChartNode().getChart().getXYPlot().setDomainAxis(numberAxis);
        this.getDynamicJFreeChartNode().setBufferedSeries();
        this.addListener(new ControlGraph.Adapter(){

            public void zoomChanged() {
                RotationGraph.this.getDynamicJFreeChartNode().forceUpdateAll();
            }
        });
    }

    public RotationGraphNumberAxis getVerticalAxis() {
        return this.verticalAxis;
    }

    public String getTitle() {
        return this.title;
    }

    protected ControlGraph.TitleLayer createTitleLayer() {
        return new RotationTitleLayer();
    }

    private ControlGraphSeries getPrimarySeries(ControlGraphSeries controlGraphSeries) {
        for (int i = 0; i < this.seriesPairs.size(); ++i) {
            SeriesPair seriesPair = (SeriesPair)this.seriesPairs.get(i);
            if (seriesPair.getB() != controlGraphSeries) continue;
            return seriesPair.getA();
        }
        return null;
    }

    private boolean isSecondarySeries(ControlGraphSeries controlGraphSeries) {
        return this.secondarySeries.contains(controlGraphSeries);
    }

    public void addSecondarySeries(ControlGraphSeries controlGraphSeries) {
        this.secondarySeries.add(controlGraphSeries);
        super.addSeries(controlGraphSeries);
    }

    public void setSecondarySeriesVisible(boolean bl) {
        for (int i = 0; i < this.secondarySeries.size(); ++i) {
            ((ControlGraphSeries)this.secondarySeries.get(i)).setVisible(bl);
        }
    }

    public SeriesPair addSeriesPair(String string, ControlGraphSeries controlGraphSeries, ControlGraphSeries controlGraphSeries2, RotationBody rotationBody, RotationBody rotationBody2) {
        SeriesPair seriesPair = new SeriesPair(string, controlGraphSeries, controlGraphSeries2, rotationBody, rotationBody2);
        this.seriesPairs.add(seriesPair);
        this.addSeries(controlGraphSeries);
        this.addSecondarySeries(controlGraphSeries2);
        return seriesPair;
    }

    public int getSeriesPairCount() {
        return this.seriesPairs.size();
    }

    public SeriesPair getSeriesPair(int n) {
        return (SeriesPair)this.seriesPairs.get(n);
    }

    public static class RotationGraphNumberAxis
    extends NumberAxis {
        public RotationGraphNumberAxis(String string) {
            super(string);
            this.setLabelFont(RotationLookAndFeel.getGraphVerticalAxisLabelFont());
        }

        protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
            super.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
            this.setTickUnit(new NumberTickUnit(this.getTickUnit().getSize() * 2.0), false, false);
        }
    }

    public static class SeriesPair {
        private String name;
        private ControlGraphSeries a;
        private ControlGraphSeries b;
        private RotationBody body0;
        private RotationBody body1;
        private boolean visible;

        public SeriesPair(String string, ControlGraphSeries controlGraphSeries, ControlGraphSeries controlGraphSeries2, RotationBody rotationBody, RotationBody rotationBody2) {
            this.name = string;
            this.a = controlGraphSeries;
            this.b = controlGraphSeries2;
            this.body0 = rotationBody;
            this.body1 = rotationBody2;
            this.visible = controlGraphSeries.isVisible();
            rotationBody.addListener(new RotationBody.Adapter(this){
                private final /* synthetic */ SeriesPair this$0;
                {
                    this.this$0 = seriesPair;
                }

                public void platformStateChanged() {
                    SeriesPair.access$200(this.this$0);
                }

                public void displayGraphChanged() {
                    SeriesPair.access$200(this.this$0);
                }
            });
            rotationBody2.addListener(new RotationBody.Adapter(this){
                private final /* synthetic */ SeriesPair this$0;
                {
                    this.this$0 = seriesPair;
                }

                public void platformStateChanged() {
                    SeriesPair.access$200(this.this$0);
                }

                public void displayGraphChanged() {
                    SeriesPair.access$200(this.this$0);
                }
            });
            controlGraphSeries2.addListener(new ControlGraphSeries.Adapter(this){
                private final /* synthetic */ SeriesPair this$0;
                {
                    this.this$0 = seriesPair;
                }

                public void visibilityChanged() {
                    SeriesPair.access$200(this.this$0);
                }
            });
        }

        private void updateVisibility() {
            this.a.setVisible(this.visible && this.body0.getDisplayGraph());
            this.b.setVisible(this.visible && this.body1.isOnPlatform() && this.body1.getDisplayGraph());
        }

        public String getName() {
            return this.name;
        }

        public ControlGraphSeries getA() {
            return this.a;
        }

        public ControlGraphSeries getB() {
            return this.b;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean bl) {
            if (this.visible != bl) {
                this.visible = bl;
                this.updateVisibility();
            }
        }

        static /* synthetic */ void access$200(SeriesPair seriesPair) {
            seriesPair.updateVisibility();
        }
    }

    public class RotationTitleLayer
    extends ControlGraph.TitleLayer {
        public void addReadoutNode(ReadoutTitleNode readoutTitleNode) {
            if (RotationGraph.this.isSecondarySeries(readoutTitleNode.getSeries())) {
                ControlGraphSeries controlGraphSeries = RotationGraph.this.getPrimarySeries(readoutTitleNode.getSeries());
                ReadoutTitleNode readoutTitleNode2 = super.getReadoutNode(controlGraphSeries);
                readoutTitleNode.setOffset(readoutTitleNode2.getOffset().getX(), readoutTitleNode2.getOffset().getY() + readoutTitleNode2.getFullBounds().getHeight() + 3.0);
            } else {
                readoutTitleNode.setOffset(this.getFullBounds().getWidth(), 0.0);
            }
            this.addChild(readoutTitleNode);
        }
    }
}

