/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.graphs;

import edu.colorado.phet.common.motion.graphs.ControlGraphSeries;
import edu.colorado.phet.common.motion.graphs.GraphControlSeriesNode;
import edu.colorado.phet.common.motion.graphs.GraphSuiteSet;
import edu.colorado.phet.common.motion.graphs.MinimizableControlGraph;
import edu.colorado.phet.common.motion.graphs.ShadowJLabel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.rotation.AngleUnitModel;
import edu.colorado.phet.rotation.RotationColorScheme;
import edu.colorado.phet.rotation.graphs.AngularUnitGraph;
import edu.colorado.phet.rotation.graphs.RotationGraph;
import edu.colorado.phet.rotation.graphs.RotationMinimizableControlGraph;
import edu.colorado.phet.rotation.graphs.RotationSeriesSelectionPanel;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Stroke;

public class RotationGraphSet
extends GraphSuiteSet {
    private Stroke body0Stroke = new BasicStroke(3.0f, 1, 0, 1.0f);
    private Stroke body1Stroke = new BasicStroke(4.0f, 1, 0, 1.0f, new float[]{10.0f, 10.0f}, 0.0f);
    private Stroke platformStroke = new BasicStroke(4.0f, 1, 0, 1.0f);
    private RotationModel model;
    private String ANGLE_UNITS_RAD = "radians";
    private String ANGLE_UNITS_DEG = "degrees";
    private String ACCEL_UNITS = "m/s^2";

    public RotationGraphSet(PhetPCanvas phetPCanvas, RotationModel rotationModel, AngleUnitModel angleUnitModel) {
        this.model = rotationModel;
        RotationBody rotationBody = rotationModel.getRotationBody(0);
        RotationBody rotationBody2 = rotationModel.getRotationBody(1);
        RotationMinimizableControlGraph rotationMinimizableControlGraph = new RotationMinimizableControlGraph("\u03b8", new AngularUnitGraph(phetPCanvas, rotationModel.getPlatformAngleVariable(), "\u03b8", "Angle", angleUnitModel, this.ANGLE_UNITS_RAD, this.ANGLE_UNITS_DEG, Math.PI * -3, Math.PI * 3, new PImage(RotationGraphSet.loadArrow("blue-arrow.png")), rotationModel, true, rotationModel.getTimeSeriesModel(), rotationModel.getPositionDriven(), 20.0, rotationModel.getRotationPlatform()));
        rotationMinimizableControlGraph.addSeries(new ControlGraphSeries("Angle", RotationColorScheme.ANGLE_SUITE.getPlatform(), "\u03b8", this.ANGLE_UNITS_RAD, rotationModel.getPlatformAngleVariable(), rotationModel.getPlatformAngleTimeSeries(), this.platformStroke, true, "platform"));
        rotationMinimizableControlGraph.addSeriesPair("Angle", new ControlGraphSeries("Angle", RotationColorScheme.ANGLE_SUITE.getLadybug(), "\u03b8", this.ANGLE_UNITS_RAD, rotationBody.getAngleVariable(), rotationBody.getAngleTimeSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("Angle (2)", RotationColorScheme.ANGLE_SUITE.getBeetle(), "\u03b8", this.ANGLE_UNITS_RAD, rotationBody2.getAngleVariable(), rotationBody2.getAngleTimeSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        RotationMinimizableControlGraph rotationMinimizableControlGraph2 = new RotationMinimizableControlGraph("\u03c9", new AngularUnitGraph(phetPCanvas, rotationModel.getPlatformVelocityVariable(), "\u03c9", "Angular Velocity", angleUnitModel, "rad/s", "degrees/s", -5.0, 5.0, new PImage(RotationGraphSet.loadArrow("green-arrow.png")), rotationModel, true, rotationModel.getTimeSeriesModel(), rotationModel.getVelocityDriven(), 20.0, rotationModel.getRotationPlatform()));
        rotationMinimizableControlGraph2.addSeries(new ControlGraphSeries("Angular Velocity", RotationColorScheme.ANG_VEL_SUITE.getPlatform(), "\u03c9", "rad/s", rotationModel.getPlatformVelocityVariable(), rotationModel.getPlatformVelocityTimeSeries(), this.platformStroke, true, "platform"));
        rotationMinimizableControlGraph2.addSeriesPair("Angular Velocity", new ControlGraphSeries("Angular Velocity", RotationColorScheme.ANG_VEL_SUITE.getLadybug(), "\u03c9", "rad/s", rotationBody.getAngularVelocityVariable(), rotationBody.getAngularVelocityTimeSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("Angular Velocity (2)", RotationColorScheme.ANG_VEL_SUITE.getBeetle(), "\u03c9", "rad/s", rotationModel.getPlatformVelocityVariable(), rotationModel.getPlatformVelocityTimeSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        RotationMinimizableControlGraph rotationMinimizableControlGraph3 = new RotationMinimizableControlGraph("\u03b1", new AngularUnitGraph(phetPCanvas, rotationModel.getPlatformAccelVariable(), "\u03b1", "Angular Acceleration", angleUnitModel, "rad/s^2", "degrees/s^2", -1.1, 1.1, new PImage(RotationGraphSet.loadArrow("red-arrow.png")), rotationModel, true, rotationModel.getTimeSeriesModel(), rotationModel.getAccelDriven(), 20.0, rotationModel.getRotationPlatform()));
        rotationMinimizableControlGraph3.addSeries(new ControlGraphSeries("Platform Ang Accel", RotationColorScheme.ANG_ACC_SUITE.getPlatform(), "\u03b1", "rad/s^2", rotationModel.getPlatformAccelVariable(), rotationModel.getPlatformAccelTimeSeries(), this.platformStroke, true, "platform"));
        rotationMinimizableControlGraph3.addSeriesPair("Angular Acceleration", new ControlGraphSeries("Angular Acceleration", RotationColorScheme.ANG_ACC_SUITE.getLadybug(), "\u03b1", "rad/s^2", rotationBody.getAngularAccelerationVariable(), rotationBody.getAngularAccelerationTimeSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("Angular Acceleration (2) ", RotationColorScheme.ANG_ACC_SUITE.getBeetle(), "\u03b1", "rad/s^2", rotationBody2.getAngularAccelerationVariable(), rotationBody2.getAngularAccelerationTimeSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        RotationMinimizableControlGraph rotationMinimizableControlGraph4 = new RotationMinimizableControlGraph("x & y", new RotationGraph(phetPCanvas, rotationBody.getXPositionVariable(), "x", "Position", "m", -5.0, 5.0, new PImage(RotationGraphSet.loadArrow("blue-arrow.png")), rotationModel, false, rotationModel.getTimeSeriesModel(), null, 20.0, null));
        rotationMinimizableControlGraph4.addSeriesPair("X-Position", new ControlGraphSeries("X-Position", RotationColorScheme.X_COLOR, "x", "m", rotationBody.getXPositionVariable(), rotationBody.getXPositionTimeSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("X-Position(2)", this.darken(RotationColorScheme.X_COLOR), "x", "m", rotationBody2.getXPositionVariable(), rotationBody2.getXPositionTimeSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        rotationMinimizableControlGraph4.addSeriesPair("Y-Position", new ControlGraphSeries("Y-Position", RotationColorScheme.Y_COLOR, "y", "m", rotationBody.getYPositionVariable(), rotationBody.getYPositionTimeSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("Y-Position(2)", this.darken(RotationColorScheme.Y_COLOR), "y", "m", rotationBody2.getYPositionVariable(), rotationBody2.getYPositionTimeSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        RotationMinimizableControlGraph rotationMinimizableControlGraph5 = new RotationMinimizableControlGraph("v", new RotationGraph(phetPCanvas, rotationBody.getXVelocityVariable(), "vx", "Velocity", "m/s", -15.0, 15.0, new PImage(RotationGraphSet.loadArrow("blue-arrow.png")), rotationModel, false, rotationModel.getTimeSeriesModel(), null, 20.0, null));
        rotationMinimizableControlGraph5.addSeriesPair("Speed", new ControlGraphSeries("Speed", RotationColorScheme.VM_COLOR, "|v|", "m/s", rotationBody.getSpeedVariable(), rotationBody.getSpeedSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("Speed(2)", this.darken(RotationColorScheme.VM_COLOR), "|v|", "m/s", rotationBody2.getSpeedVariable(), rotationBody2.getSpeedSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        RotationGraph.SeriesPair seriesPair = rotationMinimizableControlGraph5.addSeriesPair("X-Velocity", new ControlGraphSeries("X-Velocity", RotationColorScheme.VX_COLOR, "vx", "m/s", rotationBody.getXVelocityVariable(), rotationBody.getXVelocityTimeSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("X-Velocity(2)", this.darken(RotationColorScheme.VX_COLOR), "vx", "m/s", rotationBody2.getXVelocityVariable(), rotationBody2.getXVelocityTimeSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        RotationGraph.SeriesPair seriesPair2 = rotationMinimizableControlGraph5.addSeriesPair("Y-Velocity", new ControlGraphSeries("Y-Velocity", RotationColorScheme.VY_COLOR, "vy", "m/s", rotationBody.getYVelocityVariable(), rotationBody.getYVelocityTimeSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("Y-Velocity(2)", this.darken(RotationColorScheme.VY_COLOR), "vy", "m/s", rotationBody2.getYVelocityVariable(), rotationBody2.getYVelocityTimeSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        seriesPair.setVisible(false);
        seriesPair2.setVisible(false);
        RotationMinimizableControlGraph rotationMinimizableControlGraph6 = new RotationMinimizableControlGraph("a", new RotationGraph(phetPCanvas, rotationBody.getXAccelVariable(), "ax", "Acceleration", this.ACCEL_UNITS, -16.66666666666667, 16.66666666666667, new PImage(RotationGraphSet.loadArrow("red-arrow.png")), rotationModel, false, rotationModel.getTimeSeriesModel(), null, 20.0, null));
        rotationMinimizableControlGraph6.addSeriesPair("|Acceleration|", new ControlGraphSeries("|Acceleration|", RotationColorScheme.AM_COLOR, "a", this.ACCEL_UNITS, rotationBody.getAccelMagnitudeVariable(), rotationBody.getAccelMagnitudeSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("|Acceleration|(2)", this.darken(RotationColorScheme.AM_COLOR), "a", this.ACCEL_UNITS, rotationBody2.getAccelMagnitudeVariable(), rotationBody2.getAccelMagnitudeSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        RotationGraph.SeriesPair seriesPair3 = rotationMinimizableControlGraph6.addSeriesPair("X-Acceleration", new ControlGraphSeries("X-Acceleration", RotationColorScheme.AX_COLOR, "ax", this.ACCEL_UNITS, rotationBody.getXAccelVariable(), rotationBody.getXAccelTimeSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("X-Acceleration(2)", this.darken(RotationColorScheme.AX_COLOR), "ax", this.ACCEL_UNITS, rotationBody2.getXAccelVariable(), rotationBody2.getXAccelTimeSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        RotationGraph.SeriesPair seriesPair4 = rotationMinimizableControlGraph6.addSeriesPair("Y-Acceleration", new ControlGraphSeries("Y-Acceleration", RotationColorScheme.AY_COLOR, "ay", this.ACCEL_UNITS, rotationBody.getYAccelVariable(), rotationBody.getYAccelTimeSeries(), this.body0Stroke, "ladybug"), new ControlGraphSeries("Y-Acceleration(2)", this.darken(RotationColorScheme.AY_COLOR), "ay", this.ACCEL_UNITS, rotationBody2.getYAccelVariable(), rotationBody2.getYAccelTimeSeries(), this.body1Stroke, "beetle"), rotationBody, rotationBody2);
        seriesPair3.setVisible(false);
        seriesPair4.setVisible(false);
        this.addGraphSuite(new RotationMinimizableControlGraph[]{rotationMinimizableControlGraph, rotationMinimizableControlGraph2, rotationMinimizableControlGraph4});
        this.addGraphSuite(new RotationMinimizableControlGraph[]{rotationMinimizableControlGraph, rotationMinimizableControlGraph2, rotationMinimizableControlGraph3});
        this.addGraphSuite(new RotationMinimizableControlGraph[]{rotationMinimizableControlGraph, rotationMinimizableControlGraph2, rotationMinimizableControlGraph5});
        this.addGraphSuite(new RotationMinimizableControlGraph[]{rotationMinimizableControlGraph, rotationMinimizableControlGraph2, rotationMinimizableControlGraph6});
        this.addSeriesSelectionPanels();
        rotationBody2.addListener(new RotationBody.Adapter(){

            public void platformStateChanged() {
                RotationGraphSet.this.updateBody1Series();
            }
        });
        this.updateBody1Series();
    }

    private Color darken(Color color) {
        return this.darken(color, 150);
    }

    private Color darken(Color color, int n) {
        return new Color(Math.max(color.getRed() - n, 0), Math.max(color.getGreen() - n, 0), Math.max(color.getBlue() - n, 0));
    }

    private void addSeriesSelectionPanels() {
        MinimizableControlGraph[] minimizableControlGraphArray = this.getAllGraphs();
        for (int i = 0; i < minimizableControlGraphArray.length; ++i) {
            RotationMinimizableControlGraph rotationMinimizableControlGraph = (RotationMinimizableControlGraph)minimizableControlGraphArray[i];
            if (rotationMinimizableControlGraph.getRotationControlGraph().getSeriesPairCount() <= 1) continue;
            VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
            RotationSeriesSelectionPanel rotationSeriesSelectionPanel = new RotationSeriesSelectionPanel(rotationMinimizableControlGraph.getRotationControlGraph());
            ShadowJLabel shadowJLabel = new ShadowJLabel(rotationMinimizableControlGraph.getRotationControlGraph().getTitle(), rotationMinimizableControlGraph.getControlGraph().getControlGraphSeries(0).getColor(), GraphControlSeriesNode.LABEL_FONT);
            ((Container)verticalLayoutPanel).add(shadowJLabel);
            ((Container)verticalLayoutPanel).add(rotationSeriesSelectionPanel);
            minimizableControlGraphArray[i].getControlGraph().addControl(verticalLayoutPanel);
        }
    }

    private void updateBody1Series() {
        for (int i = 0; i < this.getAllGraphs().length; ++i) {
            RotationMinimizableControlGraph rotationMinimizableControlGraph = (RotationMinimizableControlGraph)this.getAllGraphs()[i];
            ((RotationGraph)rotationMinimizableControlGraph.getControlGraph()).setSecondarySeriesVisible(this.model.getRotationBody(1).isOnPlatform());
        }
    }
}

