/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.model;

import JSci.maths.LinearMath;
import JSci.maths.vectors.AbstractDoubleVector;
import edu.colorado.phet.common.motion.MotionMath;
import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.motion.model.ISimulationVariable;
import edu.colorado.phet.common.motion.model.ITimeSeries;
import edu.colorado.phet.common.motion.model.MotionBody;
import edu.colorado.phet.common.motion.model.MotionBodyState;
import edu.colorado.phet.common.motion.model.TimeData;
import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.model.SeriesVariable;
import edu.colorado.phet.rotation.tests.CircularRegression;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class RotationBody {
    private MotionBody xBody;
    private MotionBody yBody;
    private UpdateStrategy updateStrategy = new OffPlatform();
    private SeriesVariable speed;
    private SeriesVariable accel;
    private SeriesVariable angle;
    private double orientation = 0.0;
    private ITimeSeries orientationSeries = new DefaultTimeSeries();
    private String imageName;
    private boolean constrained;
    private RotationPlatform rotationPlatform;
    private boolean displayGraph = true;
    private CircularRegression.Circle circle;
    private CircularRegression circularRegression = new CircularRegression();
    private ArrayList listeners = new ArrayList();
    private SeriesVariable angularVelocity;
    private SeriesVariable angularAccel;

    public RotationBody() {
        this("ladybug.gif");
    }

    public RotationBody(String string) {
        this(string, false);
    }

    public RotationBody(String string, boolean bl) {
        this.imageName = string;
        this.constrained = bl;
        this.xBody = new MotionBody();
        this.yBody = new MotionBody();
        this.speed = new SeriesVariable();
        this.accel = new SeriesVariable();
        this.angle = new SeriesVariable();
        this.angularVelocity = new SeriesVariable();
        this.angularAccel = new SeriesVariable();
    }

    public void setOffPlatform() {
        if (!this.isOffPlatform()) {
            this.setUpdateStrategy(new OffPlatform());
            this.rotationPlatform = null;
            this.notifyPlatformStateChanged();
        }
    }

    private void notifyPlatformStateChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).platformStateChanged();
        }
    }

    private void setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy.detach();
        this.updateStrategy = updateStrategy;
    }

    public void setOnPlatform(RotationPlatform rotationPlatform) {
        if (!this.isOnPlatform(rotationPlatform)) {
            this.setUpdateStrategy(new OnPlatform(rotationPlatform));
            this.rotationPlatform = rotationPlatform;
            this.notifyPlatformStateChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void translate(double d, double d2) {
        this.setPosition(this.getPosition().getX() + d, this.getPosition().getY() + d2);
    }

    public double getOrientation() {
        return this.orientation;
    }

    public double getX() {
        return this.xBody.getPosition();
    }

    public double getY() {
        return this.yBody.getPosition();
    }

    public double getAngleOverPlatform() {
        return new Vector2D.Double(this.rotationPlatform.getCenter(), this.getPosition()).getAngle();
    }

    public void stepInTime(double d, double d2) {
        Point2D point2D = this.getPosition();
        if (this.isOffPlatform()) {
            this.updateOffPlatform(d);
        } else {
            this.updateOnPlatform(d);
        }
        if (!this.getPosition().equals(point2D)) {
            this.notifyPositionChanged();
        }
        this.speed.updateSeriesAndState(this.getVelocity().getMagnitude(), d);
        this.accel.updateSeriesAndState(this.getAcceleration().getMagnitude(), d);
        this.orientationSeries.addValue(this.getOrientation(), d);
        this.notifyVectorsUpdated();
    }

    public void clear() {
        this.xBody.clear();
        this.yBody.clear();
        this.speed.clear();
        this.accel.setValue(0.0);
        this.accel.clear();
        this.angle.clear();
        this.orientationSeries.clear();
        this.angularVelocity.clear();
        this.angularAccel.clear();
    }

    private void updateOffPlatform(double d) {
        Object object;
        Vector2D vector2D = this.getAcceleration();
        this.xBody.getMotionBodySeries().addPositionData(this.xBody.getPosition(), d);
        this.yBody.getMotionBodySeries().addPositionData(this.yBody.getPosition(), d);
        int n = 6;
        TimeData timeData = MotionMath.getDerivative(this.xBody.getMotionBodySeries().getRecentPositionTimeSeries(Math.min(n, this.xBody.getMotionBodySeries().getPositionSampleCount())));
        this.xBody.getMotionBodySeries().addVelocityData(timeData.getValue(), timeData.getTime());
        TimeData timeData2 = MotionMath.getDerivative(this.yBody.getMotionBodySeries().getRecentPositionTimeSeries(Math.min(n, this.yBody.getMotionBodySeries().getPositionSampleCount())));
        this.yBody.getMotionBodySeries().addVelocityData(timeData2.getValue(), timeData2.getTime());
        Point2D[] point2DArray = this.getPointHistory(25);
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2DArray[0].getX(), point2DArray[0].getY(), 0.0, 0.0);
        for (int i = 1; i < point2DArray.length; ++i) {
            Point2D point2D = point2DArray[i];
            double_.add(point2D);
        }
        if (double_.getWidth() <= 0.2 && double_.getHeight() <= 0.2) {
            this.updateAccelByDerivative();
            this.updateXYStateFromSeries();
            return;
        }
        this.circle = this.circularRegression.getCircle(point2DArray, 50, this.circle);
        if (this.circle.getRadius() > 5.0) {
            this.circle = this.circularRegression.getCircle(point2DArray, 50, null);
        }
        double d2 = 0.01;
        double d3 = 0.15;
        double d4 = (d3 + d2) / 2.0;
        double d5 = this.getLinearRegressionMSE(point2DArray);
        if (this.circle.getRadius() >= 0.5 && this.circle.getRadius() <= 5.0 && this.circle.getMeanSquaredError(point2DArray) < d4 && d5 > 0.01) {
            object = new Vector2D.Double(new Point2D.Double(this.xBody.getPosition(), this.yBody.getPosition()), this.circle.getCenter2D());
            double d6 = (timeData.getValue() * timeData.getValue() + timeData2.getValue() * timeData2.getValue()) / this.circle.getRadius();
            if (object.getMagnitude() < 0.1) {
                object = new Vector2D.Double(0.1, 0.1);
            }
            object = object.getInstanceOfMagnitude(d6);
            object = vector2D.getAddedInstance((AbstractVector2D)object).getScaledInstance(0.5);
            this.xBody.getMotionBodySeries().addAccelerationData(object.getX(), d);
            this.yBody.getMotionBodySeries().addAccelerationData(object.getY(), d);
        } else {
            this.updateAccelByDerivative();
        }
        this.updateXYStateFromSeries();
        this.angle.updateSeriesAndState(this.getUserSetAngle(), d);
        object = MotionMath.getDerivative(MotionMath.smooth(this.angle.getRecentSeries(Math.min(n, this.angle.getSampleCount())), 4));
        this.angularVelocity.updateSeriesAndState(((TimeData)object).getValue(), ((TimeData)object).getTime());
        TimeData timeData3 = MotionMath.getDerivative(MotionMath.smooth(this.angularVelocity.getRecentSeries(Math.min(n, this.angularVelocity.getSampleCount())), 4));
        this.angularAccel.updateSeriesAndState(timeData3.getValue(), timeData3.getTime());
    }

    private double getUserSetAngle() {
        return this.getLastAngle() + this.getDTheta();
    }

    private double getLastAngle() {
        return this.angle.getSampleCount() > 0 ? this.angle.getLastValue() : this.getAngleNoWindingNumber();
    }

    private double getDTheta() {
        double d = this.getAngleNoWindingNumber();
        double d2 = this.getLastAngle();
        AbstractVector2D abstractVector2D = Vector2D.Double.parseAngleAndMagnitude(1.0, d2);
        double d3 = d - (d2 = abstractVector2D.getAngle());
        if (d3 > Math.PI) {
            d3 -= Math.PI * 2;
        } else if (d3 < -Math.PI) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    private double getAngleNoWindingNumber() {
        return new Vector2D.Double(this.getX(), this.getY()).getAngle();
    }

    private void updateAccelByDerivative() {
        int n = 6;
        TimeData timeData = MotionMath.getDerivative(this.xBody.getMotionBodySeries().getRecentVelocityTimeSeries(Math.min(n, this.xBody.getMotionBodySeries().getVelocitySampleCount())));
        this.xBody.getMotionBodySeries().addAccelerationData(timeData.getValue(), timeData.getTime());
        TimeData timeData2 = MotionMath.getDerivative(this.yBody.getMotionBodySeries().getRecentVelocityTimeSeries(Math.min(n, this.yBody.getMotionBodySeries().getVelocitySampleCount())));
        this.yBody.getMotionBodySeries().addAccelerationData(timeData2.getValue(), timeData2.getTime());
    }

    private double getLinearRegressionMSE(Point2D[] point2DArray) {
        double[][] dArray = new double[2][point2DArray.length];
        for (int i = 0; i < dArray[0].length; ++i) {
            dArray[0][i] = point2DArray[i].getX();
            dArray[1][i] = point2DArray[i].getY();
        }
        AbstractDoubleVector abstractDoubleVector = LinearMath.linearRegression(dArray);
        double d = abstractDoubleVector.getComponent(0);
        double d2 = abstractDoubleVector.getComponent(1);
        double d3 = 0.0;
        for (int i = 0; i < point2DArray.length; ++i) {
            Point2D point2D = point2DArray[i];
            double d4 = d + d2 * point2D.getX();
            double d5 = point2D.getY();
            d3 += (d4 - d5) * (d4 - d5);
        }
        return d3 / (double)point2DArray.length;
    }

    public CircularRegression.Circle getCircle() {
        return this.circle;
    }

    public Point2D[] getPointHistory(int n) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>(n);
        for (int i = 0; i < this.xBody.getXTimeSeries().getSampleCount() && i < n; ++i) {
            arrayList.add(new Point2D.Double(this.xBody.getXTimeSeries().getRecentData(i).getValue(), this.yBody.getXTimeSeries().getRecentData(i).getValue()));
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new Point2D.Double[0]);
    }

    public boolean isOnPlatform() {
        return this.updateStrategy instanceof OnPlatform;
    }

    private boolean isOnPlatform(RotationPlatform rotationPlatform) {
        if (this.updateStrategy instanceof OnPlatform) {
            OnPlatform onPlatform = (OnPlatform)this.updateStrategy;
            return onPlatform.rotationPlatform == rotationPlatform;
        }
        return false;
    }

    private boolean isOffPlatform() {
        return this.updateStrategy instanceof OffPlatform;
    }

    private void notifyVectorsUpdated() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.speedAndAccelerationUpdated();
        }
    }

    private void updateVectorsOnPlatform() {
        double d = this.rotationPlatform.getVelocity();
        double d2 = this.getPosition().distance(this.rotationPlatform.getCenter());
        Point2D point2D = Vector2D.Double.parseAngleAndMagnitude(d2, this.getAngleOverPlatform()).getDestination(this.rotationPlatform.getCenter());
        Vector2D.Double double_ = new Vector2D.Double(point2D, this.rotationPlatform.getCenter());
        AbstractVector2D abstractVector2D = double_.getInstanceOfMagnitude(d2 * d).getNormalVector();
        AbstractVector2D abstractVector2D2 = double_.getInstanceOfMagnitude(d2 * d * d);
        this.xBody.getVVariable().setValue(abstractVector2D.getX());
        this.yBody.getVVariable().setValue(abstractVector2D.getY());
        this.xBody.getAVariable().setValue(abstractVector2D2.getX());
        this.yBody.getAVariable().setValue(abstractVector2D2.getY());
    }

    private void updateOnPlatform(double d) {
        double d2 = this.rotationPlatform.getVelocity();
        double d3 = this.getPosition().distance(this.rotationPlatform.getCenter());
        Point2D point2D = Vector2D.Double.parseAngleAndMagnitude(d3, this.getAngleOverPlatform()).getDestination(this.rotationPlatform.getCenter());
        Vector2D.Double double_ = new Vector2D.Double(point2D, this.rotationPlatform.getCenter());
        AbstractVector2D abstractVector2D = double_.getInstanceOfMagnitude(d3 * d2).getNormalVector();
        AbstractVector2D abstractVector2D2 = double_.getInstanceOfMagnitude(d3 * d2 * d2);
        this.addPositionData(point2D, d);
        this.addVelocityData(abstractVector2D, d);
        this.addAccelerationData(abstractVector2D2, d);
        this.updateXYStateFromSeries();
        this.angle.updateSeriesAndState(this.getUserSetAngle(), this.rotationPlatform.getXTimeSeries().getTime());
        this.angularVelocity.updateSeriesAndState(this.rotationPlatform.getVelocity(), this.rotationPlatform.getVTimeSeries().getTime());
        this.angularAccel.updateSeriesAndState(this.rotationPlatform.getAcceleration(), this.rotationPlatform.getATimeSeries().getTime());
        this.checkCentripetalAccel();
    }

    public void checkCentripetalAccel() {
        if (this.rotationPlatform == null) {
            return;
        }
        Vector2D.Double double_ = new Vector2D.Double(this.getPosition(), this.rotationPlatform.getCenter());
        Vector2D vector2D = this.getAcceleration();
        double d = double_.getAngle() - vector2D.getAngle();
        if (Math.abs(d) > 0.01 & vector2D.getMagnitude() > 1.0E-9) {
            // empty if block
        }
    }

    private void updateXYStateFromSeries() {
        this.xBody.updateStateFromSeries();
        this.yBody.updateStateFromSeries();
    }

    private void addAccelerationData(AbstractVector2D abstractVector2D, double d) {
        this.xBody.getMotionBodySeries().addAccelerationData(abstractVector2D.getX(), d);
        this.yBody.getMotionBodySeries().addAccelerationData(abstractVector2D.getY(), d);
    }

    private void addVelocityData(AbstractVector2D abstractVector2D, double d) {
        this.xBody.getMotionBodySeries().addVelocityData(abstractVector2D.getX(), d);
        this.yBody.getMotionBodySeries().addVelocityData(abstractVector2D.getY(), d);
    }

    private void addPositionData(Point2D point2D, double d) {
        this.xBody.getMotionBodySeries().addPositionData(point2D.getX(), d);
        this.yBody.getMotionBodySeries().addPositionData(point2D.getY(), d);
    }

    public Vector2D getAcceleration() {
        return new Vector2D.Double(this.xBody.getAcceleration(), this.yBody.getAcceleration());
    }

    public Vector2D getVelocity() {
        return new Vector2D.Double(this.xBody.getVelocity(), this.yBody.getVelocity());
    }

    public ISimulationVariable getXPositionVariable() {
        return this.xBody.getXVariable();
    }

    public ISimulationVariable getXVelocityVariable() {
        return this.xBody.getVVariable();
    }

    public ITimeSeries getXVelocityTimeSeries() {
        return this.xBody.getVTimeSeries();
    }

    public ISimulationVariable getYVelocityVariable() {
        return this.yBody.getVVariable();
    }

    public ITimeSeries getYVelocityTimeSeries() {
        return this.yBody.getVTimeSeries();
    }

    public ITimeSeries getXPositionTimeSeries() {
        return this.xBody.getXTimeSeries();
    }

    public ISimulationVariable getYPositionVariable() {
        return this.yBody.getXVariable();
    }

    public ITimeSeries getYPositionTimeSeries() {
        return this.yBody.getXTimeSeries();
    }

    public ISimulationVariable getXAccelVariable() {
        return this.xBody.getAVariable();
    }

    public ITimeSeries getXAccelTimeSeries() {
        return this.xBody.getATimeSeries();
    }

    public ISimulationVariable getYAccelVariable() {
        return this.yBody.getAVariable();
    }

    public ITimeSeries getYAccelTimeSeries() {
        return this.yBody.getATimeSeries();
    }

    public ISimulationVariable getSpeedVariable() {
        return this.speed.getVariable();
    }

    public ITimeSeries getSpeedSeries() {
        return this.speed.getSeries();
    }

    public ISimulationVariable getAccelMagnitudeVariable() {
        return this.accel.getVariable();
    }

    public ITimeSeries getAccelMagnitudeSeries() {
        return this.accel.getSeries();
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setTime(double d) {
        this.xBody.setTime(d);
        this.yBody.setTime(d);
        this.accel.setValueForTime(d);
        this.speed.setValueForTime(d);
        this.setOrientation(this.orientationSeries.getValueForTime(d));
        if (this.angle.getSampleCount() > 0) {
            this.angle.setValueForTime(d);
        }
        this.notifyVectorsUpdated();
        this.notifyPositionChanged();
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public ISimulationVariable getAngleVariable() {
        return this.angle.getVariable();
    }

    public ITimeSeries getAngleTimeSeries() {
        return this.angle.getSeries();
    }

    public void setDisplayGraph(boolean bl) {
        if (this.displayGraph != bl) {
            this.displayGraph = bl;
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((Listener)this.listeners.get(i)).displayGraphChanged();
            }
        }
    }

    public boolean getDisplayGraph() {
        return this.displayGraph;
    }

    public ISimulationVariable getAngularVelocityVariable() {
        return this.angularVelocity.getVariable();
    }

    public ITimeSeries getAngularVelocityTimeSeries() {
        return this.angularVelocity.getSeries();
    }

    public ISimulationVariable getAngularAccelerationVariable() {
        return this.angularAccel.getVariable();
    }

    public ITimeSeries getAngularAccelerationTimeSeries() {
        return this.angularAccel.getSeries();
    }

    private static Point2D rotate(Point2D point2D, Point2D point2D2, double d) {
        Vector2D.Double double_ = new Vector2D.Double(point2D2, point2D);
        double_.rotate(d);
        return double_.getDestination(point2D2);
    }

    private static Line2D rotate(Line2D line2D, Point2D point2D, double d) {
        return new Line2D.Double(RotationBody.rotate(line2D.getP1(), point2D, d), RotationBody.rotate(line2D.getP2(), point2D, d));
    }

    private void setPosition(Point2D point2D) {
        this.setPosition(point2D.getX(), point2D.getY());
    }

    public void setOrientation(double d) {
        this.orientation = d;
        this.notifyOrientationChanged();
    }

    private void notifyOrientationChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).orientationChanged();
        }
    }

    private void notifyPositionChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).positionChanged();
        }
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public void setPosition(double d, double d2) {
        if (this.getX() != d || this.getY() != d2) {
            this.xBody.setPosition(d);
            this.yBody.setPosition(d2);
            this.notifyPositionChanged();
        }
    }

    public static class Adapter
    implements Listener {
        public void positionChanged() {
        }

        public void speedAndAccelerationUpdated() {
        }

        public void platformStateChanged() {
        }

        public void displayGraphChanged() {
        }

        public void orientationChanged() {
        }
    }

    public static interface Listener {
        public void positionChanged();

        public void speedAndAccelerationUpdated();

        public void platformStateChanged();

        public void displayGraphChanged();

        public void orientationChanged();
    }

    private class OnPlatform
    extends UpdateStrategy
    implements MotionBodyState.Listener {
        private RotationPlatform rotationPlatform;

        public OnPlatform(RotationPlatform rotationPlatform) {
            this.rotationPlatform = rotationPlatform;
            rotationPlatform.getMotionBodyState().addListener(this);
        }

        public void positionChanged(double d) {
            Line2D.Double double_ = new Line2D.Double(RotationBody.this.getPosition(), Vector2D.Double.parseAngleAndMagnitude(0.01, RotationBody.this.getOrientation()).getDestination(RotationBody.this.getPosition()));
            RotationBody.this.setPosition(RotationBody.rotate(RotationBody.this.getPosition(), this.rotationPlatform.getCenter(), d));
            Line2D line2D = RotationBody.rotate(double_, this.rotationPlatform.getCenter(), d);
            RotationBody.this.setOrientation(new Vector2D.Double(line2D.getP1(), line2D.getP2()).getAngle());
            RotationBody.this.updateVectorsOnPlatform();
            RotationBody.this.notifyPositionChanged();
        }

        public void velocityChanged() {
        }

        public void accelerationChanged() {
        }

        public void detach() {
            this.rotationPlatform.getMotionBodyState().removeListener(this);
        }
    }

    private class OffPlatform
    extends UpdateStrategy {
        private OffPlatform() {
        }

        public void detach() {
        }
    }

    private static abstract class UpdateStrategy
    implements Serializable {
        private UpdateStrategy() {
        }

        public abstract void detach();
    }
}

