/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.model;

import edu.colorado.phet.common.motion.model.IPositionDriven;
import edu.colorado.phet.common.motion.model.ISimulationVariable;
import edu.colorado.phet.common.motion.model.ITimeSeries;
import edu.colorado.phet.common.motion.model.MotionModel;
import edu.colorado.phet.common.motion.model.PositionDriven;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.view.RotationBodyNode;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class RotationModel
extends MotionModel
implements RotationBodyNode.RotationBodyEnvironment,
IPositionDriven {
    private RotationPlatform rotationPlatform;
    private ArrayList rotationBodies = new ArrayList();

    public RotationModel(ConstantDtClock constantDtClock) {
        super(constantDtClock);
        this.rotationPlatform = new RotationPlatform();
        RotationBody rotationBody = new RotationBody("ladybug.gif", true);
        this.addRotationBody(rotationBody);
        RotationBody rotationBody2 = new RotationBody("valessiobrito_Bug_Buddy_Vec.png");
        this.addRotationBody(rotationBody2);
        this.resetAll();
    }

    private void resetBody2(RotationBody rotationBody) {
        rotationBody.setPosition(this.rotationPlatform.getCenter().getX() - this.rotationPlatform.getRadius() * Math.sqrt(2.0) / 2.0, this.rotationPlatform.getCenter().getY() - this.rotationPlatform.getRadius());
        rotationBody.setOffPlatform();
        rotationBody.setOrientation(0.0);
    }

    private void resetBody1(RotationBody rotationBody) {
        rotationBody.setPosition(this.rotationPlatform.getCenter().getX() + this.rotationPlatform.getRadius() / 2.0, this.rotationPlatform.getCenter().getY());
        rotationBody.setOnPlatform(this.rotationPlatform);
        rotationBody.setOrientation(0.0);
    }

    public void resetAll() {
        super.resetAll();
        this.rotationPlatform.reset();
        this.resetBody1(this.getRotationBody(0));
        this.resetBody2(this.getRotationBody(1));
        this.getTimeSeriesModel().setRecordMode();
        this.getTimeSeriesModel().setPaused(false);
    }

    protected void setTime(double d) {
        super.setTime(d);
        this.rotationPlatform.setTime(d);
        for (int i = 0; i < this.rotationBodies.size(); ++i) {
            this.getRotationBody(i).setTime(d);
        }
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        this.rotationPlatform.stepInTime(this.getTime(), d);
        for (int i = 0; i < this.rotationBodies.size(); ++i) {
            this.getRotationBody(i).stepInTime(this.getTime(), d);
        }
    }

    public void clear() {
        super.clear();
        this.rotationPlatform.clear();
        for (int i = 0; i < this.rotationBodies.size(); ++i) {
            this.getRotationBody(i).clear();
        }
    }

    public void dropBody(RotationBody rotationBody) {
        if (this.rotationPlatform.containsPosition(rotationBody.getPosition())) {
            rotationBody.setOnPlatform(this.rotationPlatform);
        } else {
            rotationBody.setOffPlatform();
        }
    }

    public boolean platformContains(double d, double d2) {
        return this.rotationPlatform.containsPosition(new Point2D.Double(d, d2));
    }

    public RotationPlatform getRotationPlatform() {
        return this.rotationPlatform;
    }

    private void addRotationBody(RotationBody rotationBody) {
        this.rotationBodies.add(rotationBody);
    }

    public int getNumRotationBodies() {
        return this.rotationBodies.size();
    }

    public RotationBody getRotationBody(int n) {
        return (RotationBody)this.rotationBodies.get(n);
    }

    public void setPositionDriven() {
        this.rotationPlatform.setPositionDriven();
    }

    public PositionDriven getPositionDriven() {
        return this.rotationPlatform.getPositionDriven();
    }

    public ISimulationVariable getPlatformAngleVariable() {
        return this.rotationPlatform.getXVariable();
    }

    public ITimeSeries getPlatformAngleTimeSeries() {
        return this.rotationPlatform.getXTimeSeries();
    }

    public ISimulationVariable getPlatformVelocityVariable() {
        return this.rotationPlatform.getVVariable();
    }

    public ITimeSeries getPlatformVelocityTimeSeries() {
        return this.rotationPlatform.getVTimeSeries();
    }

    public UpdateStrategy getVelocityDriven() {
        return this.rotationPlatform.getVelocityDriven();
    }

    public ISimulationVariable getPlatformAccelVariable() {
        return this.rotationPlatform.getAVariable();
    }

    public ITimeSeries getPlatformAccelTimeSeries() {
        return this.rotationPlatform.getATimeSeries();
    }

    public UpdateStrategy getAccelDriven() {
        return this.rotationPlatform.getAccelDriven();
    }
}

