/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.model;

import edu.colorado.phet.common.motion.model.MotionBody;
import edu.colorado.phet.common.phetcommon.math.SerializablePoint2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class RotationPlatform
extends MotionBody {
    private SerializablePoint2D center = new SerializablePoint2D(0.0, 0.0);
    private double radius = 3.0;
    private double innerRadius = 0.0;
    private double mass = 1.0 / ((this.innerRadius * this.innerRadius + this.radius * this.radius) / 2.0);
    private transient ArrayList listeners = new ArrayList();

    public boolean containsPosition(Point2D point2D) {
        return point2D.distance(this.center) <= this.radius && point2D.distance(this.center) >= this.innerRadius;
    }

    public Point2D getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setAngle(double d) {
        super.getMotionBodyState().setPosition(d);
    }

    public void setRadius(double d) {
        if (this.radius != d) {
            this.radius = d;
            this.notifyRadiusChanged();
        }
    }

    public void setInnerRadius(double d) {
        if (this.innerRadius != d) {
            this.innerRadius = d;
            this.notifyInnerRadiusChanged();
        }
    }

    private void notifyInnerRadiusChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.innerRadiusChanged();
        }
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public double getMomentOfInertia() {
        return 0.5 * this.mass * (this.innerRadius * this.innerRadius + this.radius * this.radius);
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyRadiusChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((Listener)this.listeners.get(i)).radiusChanged();
        }
    }

    public static interface Listener {
        public void radiusChanged();

        public void innerRadiusChanged();
    }
}

