/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.model;

import edu.colorado.phet.common.motion.model.DefaultSimulationVariable;
import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.motion.model.ISimulationVariable;
import edu.colorado.phet.common.motion.model.ITimeSeries;
import edu.colorado.phet.common.motion.model.TimeData;

public class SeriesVariable {
    private ISimulationVariable variable = new DefaultSimulationVariable();
    private ITimeSeries series = new DefaultTimeSeries();

    public void clear() {
        this.series.clear();
    }

    public void updateSeriesAndState(double d, double d2) {
        this.variable.setValue(d);
        this.series.addValue(d, d2);
    }

    public int getSampleCount() {
        return this.series.getSampleCount();
    }

    public void setValue(double d) {
        this.variable.setValue(d);
    }

    public double getValueForTime(double d) {
        return this.series.getValueForTime(d);
    }

    public ISimulationVariable getVariable() {
        return this.variable;
    }

    public ITimeSeries getSeries() {
        return this.series;
    }

    public void setValueForTime(double d) {
        this.setValue(this.getValueForTime(d));
    }

    public double getLastValue() {
        return this.series.getRecentData(0).getValue();
    }

    public TimeData[] getRecentSeries(int n) {
        return this.series.getRecentSeries(n);
    }
}

