/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.tests;

import edu.colorado.phet.common.motion.graphs.GraphSelectionControl;
import edu.colorado.phet.common.motion.graphs.GraphSetModel;
import edu.colorado.phet.common.motion.graphs.GraphSetNode;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.piccolophet.BufferedPhetPCanvas;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.rotation.AngleUnitModel;
import edu.colorado.phet.rotation.graphs.RotationGraphSet;
import edu.colorado.phet.rotation.model.RotationModel;
import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JFrame;

public class TestGraphSelectionView {
    private JFrame suiteSelectionFrame;
    private JFrame plotFrame;
    private GraphSetNode graphSetNode;
    private PhetPCanvas phetPCanvas;

    public TestGraphSelectionView() {
        new PhetLookAndFeel().initLookAndFeel();
        this.suiteSelectionFrame = new JFrame();
        this.suiteSelectionFrame.setSize(600, 600);
        this.suiteSelectionFrame.setDefaultCloseOperation(3);
        this.phetPCanvas = new BufferedPhetPCanvas();
        this.phetPCanvas.setBackground(new Color(200, 240, 200));
        RotationGraphSet rotationGraphSet = new RotationGraphSet(this.phetPCanvas, new RotationModel(new ConstantDtClock(30, 1.0)), new AngleUnitModel(true));
        GraphSetModel graphSetModel = new GraphSetModel(rotationGraphSet.getGraphSuite(0));
        GraphSelectionControl graphSelectionControl = new GraphSelectionControl(rotationGraphSet, graphSetModel);
        this.suiteSelectionFrame.getContentPane().add(graphSelectionControl);
        this.plotFrame = new JFrame();
        this.graphSetNode = new GraphSetNode(graphSetModel);
        this.phetPCanvas.addScreenChild(this.graphSetNode);
        this.plotFrame.setContentPane(this.phetPCanvas);
        this.plotFrame.setDefaultCloseOperation(3);
        this.plotFrame.setSize(400, 400);
        this.plotFrame.setLocation(this.suiteSelectionFrame.getX(), this.suiteSelectionFrame.getY() + this.suiteSelectionFrame.getHeight());
        this.phetPCanvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                TestGraphSelectionView.this.relayout();
            }
        });
        this.relayout();
    }

    private void relayout() {
        this.graphSetNode.setBounds(0.0, 0.0, this.phetPCanvas.getWidth(), this.phetPCanvas.getHeight());
    }

    public static void main(String[] stringArray) {
        new TestGraphSelectionView().start();
    }

    private void start() {
        this.suiteSelectionFrame.setVisible(true);
        this.plotFrame.setVisible(true);
    }
}

