/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.torque;

import edu.colorado.phet.common.motion.graphs.GraphSelectionControl;
import edu.colorado.phet.common.motion.graphs.GraphSetModel;
import edu.colorado.phet.common.motion.graphs.GraphSuiteSet;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractSlider;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.AbstractValueControl;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.ILayoutStrategy;
import edu.colorado.phet.common.phetcommon.view.controls.valuecontrol.LinearValueControl;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.torque.TorqueModule;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TorqueControlPanel
extends JPanel {
    private TorqueModule torqueModule;

    public TorqueControlPanel(GraphSuiteSet graphSuiteSet, GraphSetModel graphSetModel, TorqueModule torqueModule) {
        super(new GridBagLayout());
        this.torqueModule = torqueModule;
        GraphSelectionControl graphSelectionControl = new GraphSelectionControl(graphSuiteSet, graphSetModel);
        this.setBorder(BorderFactory.createTitledBorder("Controls"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        JPanel jPanel = new JPanel(new GridBagLayout());
        final RotationPlatform rotationPlatform = torqueModule.getRotationModel().getRotationPlatform();
        final TorqueSlider torqueSlider = new TorqueSlider(0.0, 200.0, rotationPlatform.getRadius(), "R=Outer Radius", "0.00", "m");
        torqueSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rotationPlatform.setRadius(torqueSlider.getValue());
            }
        });
        final TorqueSlider torqueSlider2 = new TorqueSlider(0.0, 200.0, 0.5, "r=Inner Radius", "0.00", "m");
        torqueSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rotationPlatform.setInnerRadius(torqueSlider2.getValue());
            }
        });
        final TorqueSlider torqueSlider3 = new TorqueSlider(rotationPlatform.getMass() / 10.0, rotationPlatform.getMass() * 2.0, rotationPlatform.getMass(), "Mass", "0.00", "kg");
        torqueSlider3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                rotationPlatform.setMass(torqueSlider3.getValue());
            }
        });
        TorqueSlider[] torqueSliderArray = new TorqueSlider[]{torqueSlider, torqueSlider2, torqueSlider3, new TorqueSlider(0.0, 1.0, 0.5, "Force of Brake", "0.00", "N")};
        for (int i = 0; i < torqueSliderArray.length; ++i) {
            jPanel.add((Component)torqueSliderArray[i], gridBagConstraints);
        }
        this.add((Component)jPanel, this.getConstraints(0, 0, 2));
        this.add((Component)graphSelectionControl, this.getConstraints(1, 1, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JCheckBox("Allow non-tangential forces"));
        this.add((Component)jPanel2, this.getConstraints(0, 1, 1));
    }

    private GridBagConstraints getConstraints(int n, int n2, int n3) {
        return new GridBagConstraints(n, n2, n3, 1, 1.0, 1.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0);
    }

    static class TorqueSliderLayout
    implements ILayoutStrategy {
        TorqueSliderLayout() {
        }

        public void doLayout(AbstractValueControl abstractValueControl) {
            AbstractSlider abstractSlider = abstractValueControl.getSlider();
            JFormattedTextField jFormattedTextField = abstractValueControl.getTextField();
            JLabel jLabel = abstractValueControl.getValueLabel();
            JLabel jLabel2 = abstractValueControl.getUnitsLabel();
            JPanel jPanel = new JPanel();
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
            jPanel.setLayout(easyGridBagLayout);
            easyGridBagLayout.setAnchor(17);
            easyGridBagLayout.addComponent(jLabel, 0, 0);
            easyGridBagLayout.addComponent(jFormattedTextField, 0, 1);
            easyGridBagLayout.addComponent(jLabel2, 0, 2);
            EasyGridBagLayout easyGridBagLayout2 = new EasyGridBagLayout(abstractValueControl);
            abstractValueControl.setLayout(easyGridBagLayout2);
            easyGridBagLayout2.addComponent(jPanel, 0, 0);
            easyGridBagLayout2.addComponent(abstractSlider, 0, 1);
        }
    }

    public static class TorqueSlider
    extends LinearValueControl {
        public TorqueSlider(double d, double d2, double d3, String string, String string2, String string3) {
            super(d, d2, string, string2, string3, new TorqueSliderLayout());
            this.setValue(d3);
            this.setMinorTickSpacing((d2 - d) / 20.0);
            this.setMajorTickSpacing((d2 - d) / 5.0);
            this.setPaintTickLabels(false);
        }
    }
}

