/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.torque;

import edu.colorado.phet.common.motion.model.DefaultSimulationVariable;
import edu.colorado.phet.common.motion.model.DefaultTimeSeries;
import edu.colorado.phet.common.motion.model.ISimulationVariable;
import edu.colorado.phet.common.motion.model.ITimeSeries;
import edu.colorado.phet.common.motion.model.MotionBodySeries;
import edu.colorado.phet.common.motion.model.MotionBodyState;
import edu.colorado.phet.common.motion.model.UpdateStrategy;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.rotation.model.RotationModel;

public class TorqueModel
extends RotationModel {
    private ISimulationVariable torqueVariable = new DefaultSimulationVariable();
    private ITimeSeries torqueSeries = new DefaultTimeSeries();
    private UpdateStrategy torqueDriven = new TorqueDriven();
    private ISimulationVariable forceVariable = new DefaultSimulationVariable();
    private ITimeSeries forceTimeSeries = new DefaultTimeSeries();
    private UpdateStrategy forceDriven = new ForceDriven();
    private ISimulationVariable momentOfInertiaVariable = new DefaultSimulationVariable();
    private ITimeSeries momentOfInertiaTimeSeries = new DefaultTimeSeries();
    private ISimulationVariable angularMomentumVariable = new DefaultSimulationVariable();
    private ITimeSeries angularMomentumTimeSeries = new DefaultTimeSeries();

    public TorqueModel(ConstantDtClock constantDtClock) {
        super(constantDtClock);
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        this.momentOfInertiaVariable.setValue(this.getRotationPlatform().getMomentOfInertia());
        this.momentOfInertiaTimeSeries.addValue(this.momentOfInertiaVariable.getValue(), this.getTime());
        double d2 = this.getRotationPlatform().getMomentOfInertia() * this.getRotationPlatform().getVelocity();
        this.angularMomentumVariable.setValue(d2);
        this.angularMomentumTimeSeries.addValue(d2, this.getTime());
        this.torqueSeries.addValue(this.torqueVariable.getValue(), this.getTime());
        this.forceTimeSeries.addValue(this.forceVariable.getValue(), this.getTime());
    }

    public ISimulationVariable getTorqueVariable() {
        return this.torqueVariable;
    }

    public UpdateStrategy getTorqueDriven() {
        return this.torqueDriven;
    }

    public ISimulationVariable getForceVariable() {
        return this.forceVariable;
    }

    public UpdateStrategy getForceDriven() {
        return this.forceDriven;
    }

    public ISimulationVariable getMomentOfInertiaVariable() {
        return this.momentOfInertiaVariable;
    }

    public ISimulationVariable getAngularMomentumVariable() {
        return this.angularMomentumVariable;
    }

    public class ForceDriven
    implements UpdateStrategy {
        public void update(MotionBodySeries motionBodySeries, double d, MotionBodyState motionBodyState, double d2) {
            double d3 = TorqueModel.this.forceVariable.getValue() * TorqueModel.this.getRotationPlatform().getRadius();
            double d4 = d3 / TorqueModel.this.getRotationPlatform().getMomentOfInertia();
            TorqueModel.this.torqueVariable.setValue(d3);
            double d5 = motionBodyState.getVelocity();
            motionBodySeries.addAccelerationData(d4, d2);
            motionBodySeries.addVelocityData(motionBodyState.getVelocity() + d4 * d, d2);
            motionBodySeries.addPositionData(motionBodyState.getPosition() + (motionBodyState.getVelocity() + d5) / 2.0 * d, d2);
        }
    }

    public class TorqueDriven
    implements UpdateStrategy {
        public void update(MotionBodySeries motionBodySeries, double d, MotionBodyState motionBodyState, double d2) {
            double d3 = TorqueModel.this.torqueVariable.getValue() / TorqueModel.this.getRotationPlatform().getMomentOfInertia();
            double d4 = motionBodyState.getVelocity();
            motionBodySeries.addAccelerationData(d3, d2);
            motionBodySeries.addVelocityData(motionBodyState.getVelocity() + d3 * d, d2);
            motionBodySeries.addPositionData(motionBodyState.getPosition() + (motionBodyState.getVelocity() + d4) / 2.0 * d, d2);
        }
    }
}

