/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.phetcommon.math.AbstractVector2D;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.colorado.phet.rotation.RotationColorScheme;
import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class BodyVectorLayer
extends PNode {
    private RotationModel rotationModel;
    private RotationBody rotationBody;
    private VectorNode accelArrow;
    private VectorNode velocityArrow;
    private double accelScale = 0.09;
    private double velScale = 0.24;

    public BodyVectorLayer(RotationModel rotationModel, final RotationBody rotationBody, final VectorViewModel vectorViewModel) {
        this.rotationModel = rotationModel;
        this.rotationBody = rotationBody;
        this.accelArrow = new VectorNode("a", RotationColorScheme.ACCELERATION_COLOR, new VectorFunction(){

            public AbstractVector2D getVector() {
                return rotationBody.getAcceleration().getScaledInstance(BodyVectorLayer.this.accelScale);
            }
        });
        this.addChild(this.accelArrow);
        this.velocityArrow = new VectorNode("v", RotationColorScheme.VELOCITY_COLOR, new VectorFunction(){

            public AbstractVector2D getVector() {
                return rotationBody.getVelocity().getScaledInstance(BodyVectorLayer.this.velScale);
            }
        });
        this.addChild(this.velocityArrow);
        rotationBody.addListener(new RotationBody.Adapter(){

            public void positionChanged() {
                BodyVectorLayer.this.update();
            }

            public void speedAndAccelerationUpdated() {
                BodyVectorLayer.this.update();
            }
        });
        vectorViewModel.addListener(new VectorViewModel.Listener(){

            public void visibilityChanged() {
                BodyVectorLayer.this.updateVisibility(vectorViewModel);
            }
        });
        this.update();
        this.updateVisibility(vectorViewModel);
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    private void updateVisibility(VectorViewModel vectorViewModel) {
        this.accelArrow.setVisible(vectorViewModel.isAccelerationVisible());
        this.velocityArrow.setVisible(vectorViewModel.isVelocityVisible());
    }

    private static Paint getStrokePaint() {
        return Color.black;
    }

    private static Stroke getStroke() {
        return new BasicStroke(0.015f);
    }

    private void update() {
        this.accelArrow.update();
        this.velocityArrow.update();
        this.rotationBody.checkCentripetalAccel();
    }

    static interface VectorFunction {
        public AbstractVector2D getVector();
    }

    class VectorNode
    extends PNode {
        private PhetPPath arrowNode;
        private VectorFunction vectorFunction;
        private ShadowPText labelNode;
        private double VISIBLE_THRESHOLD = 0.1;

        public VectorNode(String string, Color color, VectorFunction vectorFunction) {
            this.vectorFunction = vectorFunction;
            this.arrowNode = new PhetPPath(color, BodyVectorLayer.getStroke(), BodyVectorLayer.getStrokePaint());
            this.addChild(this.arrowNode);
            this.labelNode = new ShadowPText(string);
            this.labelNode.setFont(new Font("Lucida Sans", 1, 18));
            this.labelNode.setTextPaint(color);
            this.addChild(this.labelNode);
        }

        public void update() {
            Point2D point2D = BodyVectorLayer.this.rotationBody.getPosition();
            AbstractVector2D abstractVector2D = this.vectorFunction.getVector();
            this.arrowNode.setPathTo(new Arrow(point2D, abstractVector2D, 0.3, 0.3, 0.045, 0.75, true).getShape());
            this.labelNode.setVisible(abstractVector2D.getMagnitude() > this.VISIBLE_THRESHOLD);
            if (this.labelNode.getVisible()) {
                this.labelNode.setTransform(AffineTransform.getScaleInstance(0.015, -0.015));
                this.labelNode.setOffset(this.increase(abstractVector2D, 0.3).getDestination(point2D));
                this.labelNode.translate(-this.labelNode.getFullBounds().getWidth() / 2.0 / 0.015, -this.labelNode.getFullBounds().getHeight() / 2.0 / 0.015);
            }
        }

        private AbstractVector2D increase(AbstractVector2D abstractVector2D, double d) {
            return Math.abs(abstractVector2D.getMagnitude()) < this.VISIBLE_THRESHOLD ? abstractVector2D : abstractVector2D.getInstanceOfMagnitude(abstractVector2D.getMagnitude() + d);
        }
    }
}

