/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.umd.cs.piccolo.PNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;

public class CircleNode
extends PNode {
    private PhetPPath circlePath;
    private RotationModel rotationModel;
    private PhetPPath pointPath;

    public CircleNode(RotationModel rotationModel) {
        this.rotationModel = rotationModel;
        rotationModel.getRotationBody(1).addListener(new RotationBody.Adapter(){

            public void positionChanged() {
                CircleNode.this.update();
            }

            public void speedAndAccelerationUpdated() {
                CircleNode.this.update();
            }
        });
        this.pointPath = new PhetPPath(new BasicStroke(0.03f), (Paint)Color.green);
        this.circlePath = new PhetPPath(new BasicStroke(0.03f), (Paint)Color.blue);
        this.update();
        this.addChild(this.circlePath);
        this.addChild(this.pointPath);
    }

    private void update() {
        if (this.getVisible() && this.rotationModel.getRotationBody(1).getCircle() != null) {
            this.circlePath.setPathTo(this.rotationModel.getRotationBody(1).getCircle().toEllipse());
            this.pointPath.setPathToPolyline(this.rotationModel.getRotationBody(1).getPointHistory(25));
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.update();
        }
    }
}

