/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.motion.model.IPositionDriven;
import edu.colorado.phet.common.motion.model.MotionBodyState;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.rotation.model.RotationPlatform;
import edu.colorado.phet.rotation.util.MathUtil;
import edu.colorado.phet.rotation.view.RotationLookAndFeel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RotationPlatformNode
extends PNode {
    private PNode contentNode;
    private double angle = 0.0;
    private RotationPlatform rotationPlatform;
    private PhetPPath verticalCrossHair;
    private PhetPPath horizontalCrossHair;
    private PhetPPath innerRadiusNode;
    private double handleWidth = 0.15;
    private double handleHeight = 0.15;
    private PhetPPath handleNode;

    public RotationPlatformNode(final IPositionDriven iPositionDriven, final RotationPlatform rotationPlatform) {
        this.rotationPlatform = rotationPlatform;
        this.contentNode = new PNode();
        this.addRingNode(1.0, new Color(255, 215, 215), new Color(255, 240, 240), true);
        this.addRingNode(0.75, new Color(140, 255, 140), new Color(200, 255, 200), false);
        this.addRingNode(0.5, new Color(215, 215, 255), new Color(240, 240, 255), false);
        this.addRingNode(0.25, Color.white, Color.lightGray, false);
        this.verticalCrossHair = new PhetPPath(this.getVerticalCrossHairPath(), (Stroke)new BasicStroke(0.03f), (Paint)Color.black);
        this.contentNode.addChild(this.verticalCrossHair);
        this.horizontalCrossHair = new PhetPPath(this.getHorizontalCrossHairPath(), (Stroke)new BasicStroke(0.03f), (Paint)Color.black);
        this.contentNode.addChild(this.horizontalCrossHair);
        this.innerRadiusNode = new PhetPPath(new RotationLookAndFeel().getBackgroundColor(), (Stroke)new BasicStroke(0.015f), (Paint)Color.black);
        this.contentNode.addChild(this.innerRadiusNode);
        this.handleNode = new PhetPPath(this.createHandlePath(), Color.blue, new BasicStroke(0.015f), Color.black);
        this.contentNode.addChild(this.handleNode);
        this.addChild(this.contentNode);
        this.addInputEventListener(new PBasicInputEventHandler(){
            double initAngle;
            public Point2D initLoc;

            public void mousePressed(PInputEvent pInputEvent) {
                this.resetDrag(RotationPlatformNode.this.angle, pInputEvent);
                iPositionDriven.setPositionDriven();
            }

            public void mouseReleased(PInputEvent pInputEvent) {
            }

            public void mouseDragged(PInputEvent pInputEvent) {
                Point2D point2D = pInputEvent.getPositionRelativeTo(RotationPlatformNode.this);
                Point2D point2D2 = rotationPlatform.getCenter();
                Vector2D.Double double_ = new Vector2D.Double(point2D2, this.initLoc);
                Vector2D.Double double_2 = new Vector2D.Double(point2D2, point2D);
                double d = double_2.getAngle() - double_.getAngle();
                d = MathUtil.clampAngle(d, -Math.PI, Math.PI);
                double d2 = this.initAngle + d;
                rotationPlatform.setAngle(d2);
                this.resetDrag(d2, pInputEvent);
            }

            private void resetDrag(double d, PInputEvent pInputEvent) {
                this.initAngle = d;
                this.initLoc = pInputEvent.getPositionRelativeTo(RotationPlatformNode.this);
            }
        });
        this.addInputEventListener(new CursorHandler());
        rotationPlatform.getMotionBodyState().addListener(new MotionBodyState.Adapter(){

            public void positionChanged(double d) {
                RotationPlatformNode.this.setAngle(rotationPlatform.getPosition());
            }
        });
        this.setAngle(rotationPlatform.getPosition());
        rotationPlatform.addListener(new RotationPlatform.Listener(){

            public void radiusChanged() {
                RotationPlatformNode.this.updateRadius();
            }

            public void innerRadiusChanged() {
                RotationPlatformNode.this.updateInnerRadius();
            }
        });
        this.updateRadius();
        this.updateInnerRadius();
    }

    public RotationPlatform getRotationPlatform() {
        return this.rotationPlatform;
    }

    private void updateInnerRadius() {
        double d = this.rotationPlatform.getInnerRadius();
        this.innerRadiusNode.setPathTo(new Ellipse2D.Double(this.rotationPlatform.getCenter().getX() - d, this.rotationPlatform.getCenter().getY() - d, d * 2.0, d * 2.0));
        this.updateAngle();
    }

    private Rectangle2D.Double createHandlePath() {
        return new Rectangle2D.Double(this.rotationPlatform.getCenter().getX() + this.getRadius(), this.rotationPlatform.getCenter().getY() - this.handleHeight / 2.0, this.handleWidth, this.handleHeight);
    }

    private Line2D.Double getHorizontalCrossHairPath() {
        return new Line2D.Double(this.rotationPlatform.getCenter().getX() - this.getRadius(), this.rotationPlatform.getCenter().getY(), this.rotationPlatform.getCenter().getX() + this.getRadius(), this.rotationPlatform.getCenter().getY());
    }

    private Line2D.Double getVerticalCrossHairPath() {
        return new Line2D.Double(this.rotationPlatform.getCenter().getX(), this.rotationPlatform.getCenter().getY() - this.getRadius(), this.rotationPlatform.getCenter().getX(), this.rotationPlatform.getCenter().getY() + this.getRadius());
    }

    private void updateRadius() {
        for (int i = 0; i < this.contentNode.getChildrenCount(); ++i) {
            PNode pNode = this.contentNode.getChild(i);
            if (!(pNode instanceof RingNode)) continue;
            RingNode ringNode = (RingNode)pNode;
            ringNode.setRadius(Math.min(ringNode.getMaxRadius(), this.getRadius()));
        }
        this.verticalCrossHair.setPathTo(this.getVerticalCrossHairPath());
        this.horizontalCrossHair.setPathTo(this.getHorizontalCrossHairPath());
        this.handleNode.setPathTo(this.createHandlePath());
        this.updateAngle();
    }

    public double getRadius() {
        return this.rotationPlatform.getRadius();
    }

    private void addRingNode(double d, Color color, Color color2, boolean bl) {
        this.contentNode.addChild(new RingNode(this.rotationPlatform.getCenter().getX(), this.rotationPlatform.getCenter().getY(), d * this.getRadius(), color, color2, bl));
    }

    private void setAngle(double d) {
        if (this.angle != d) {
            this.angle = d;
            this.updateAngle();
        }
    }

    private void updateAngle() {
        this.contentNode.setRotation(0.0);
        this.contentNode.setOffset(0.0, 0.0);
        this.contentNode.rotateAboutPoint(this.angle, this.rotationPlatform.getCenter().getX(), this.rotationPlatform.getCenter().getY());
    }

    class RingNode
    extends PNode {
        private double x;
        private double y;
        private double radius;
        private double maxRadius;
        private RingPath path1;
        private RingPath path2;
        private RingPath path3;
        private RingPath path4;

        public RingNode(double d, double d2, double d3, Color color, Color color2, boolean bl) {
            this.x = d;
            this.y = d2;
            this.radius = d3;
            this.maxRadius = d3;
            this.path1 = this.addPath(color, bl, 0.0, 90.0);
            this.path2 = this.addPath(color2, bl, 90.0, 180.0);
            this.path3 = this.addPath(color, bl, 180.0, 270.0);
            this.path4 = this.addPath(color2, bl, 270.0, 360.0);
            this.update();
        }

        private RingPath addPath(Color color, boolean bl, double d, double d2) {
            RingPath ringPath = new RingPath(null, color, bl ? new BasicStroke(0.015f) : null, Color.black, d, d2);
            this.addChild(ringPath);
            return ringPath;
        }

        public double getMaxRadius() {
            return this.maxRadius;
        }

        public void setRadius(double d) {
            this.radius = d;
            this.update();
        }

        private void update() {
            this.path1.update();
            this.path2.update();
            this.path3.update();
            this.path4.update();
        }

        private Rectangle2D.Double getEllipseBounds() {
            double d = this.radius;
            return new Rectangle2D.Double(this.x - d, this.y - d, d * 2.0, d * 2.0);
        }

        class RingPath
        extends PhetPPath {
            private double minArcDegrees;
            private double maxArcDegrees;

            public RingPath(Shape shape, Paint paint, Stroke stroke, Paint paint2, double d, double d2) {
                super(shape, paint, stroke, paint2);
                this.minArcDegrees = d;
                this.maxArcDegrees = d2;
            }

            public void update() {
                Arc2D.Double double_ = new Arc2D.Double(RingNode.this.getEllipseBounds(), this.minArcDegrees, this.maxArcDegrees - this.minArcDegrees, 2);
                this.setPathTo(double_);
            }
        }
    }
}

