/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.rotation.view;

import edu.colorado.phet.common.piccolophet.nodes.RulerNode;
import edu.colorado.phet.rotation.AngleUnitModel;
import edu.colorado.phet.rotation.controls.VectorViewModel;
import edu.colorado.phet.rotation.model.RotationBody;
import edu.colorado.phet.rotation.model.RotationModel;
import edu.colorado.phet.rotation.view.BodyVectorLayer;
import edu.colorado.phet.rotation.view.CircleNode;
import edu.colorado.phet.rotation.view.RotationBodyNode;
import edu.colorado.phet.rotation.view.RotationOriginNode;
import edu.colorado.phet.rotation.view.RotationPlatformNode;
import edu.colorado.phet.rotation.view.RotationRulerNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.AffineTransform;

public class RotationPlayAreaNode
extends PNode {
    private RotationPlatformNode rotationPlatformNode;
    private PNode rotationBodyLayer = new PNode();
    private RotationModel rotationModel;
    private PNode vectorLayer = new PNode();
    private RotationOriginNode originNode;
    private RotationRulerNode rulerNode;
    private CircleNode circularMotionNode;

    public RotationPlayAreaNode(RotationModel rotationModel, VectorViewModel vectorViewModel, AngleUnitModel angleUnitModel) {
        int n;
        this.rotationModel = rotationModel;
        this.rotationPlatformNode = new RotationPlatformNode(rotationModel, rotationModel.getRotationPlatform());
        this.originNode = new RotationOriginNode(rotationModel.getRotationPlatform(), angleUnitModel);
        this.rulerNode = new RotationRulerNode(this.rotationPlatformNode.getRadius() * 2.0, 0.75, new String[]{"0", "1", "2", "3", "4", "5", "6"}, "m", 4, 14);
        this.rulerNode.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
        this.rulerNode.setVisible(false);
        this.addChild(this.rotationPlatformNode);
        this.addChild(this.rotationBodyLayer);
        this.addChild(this.vectorLayer);
        this.addChild(this.originNode);
        this.addChild(this.rulerNode);
        for (n = 0; n < rotationModel.getNumRotationBodies(); ++n) {
            this.addRotationBodyNode(rotationModel.getRotationBody(n));
        }
        for (n = 0; n < rotationModel.getNumRotationBodies(); ++n) {
            this.addVectorNode(rotationModel.getRotationBody(n), vectorViewModel);
        }
        this.circularMotionNode = new CircleNode(rotationModel);
        this.circularMotionNode.setVisible(false);
        this.addChild(this.circularMotionNode);
        this.setTransform(AffineTransform.getScaleInstance(1.0, -1.0));
    }

    public CircleNode getCircularMotionNode() {
        return this.circularMotionNode;
    }

    private void addVectorNode(RotationBody rotationBody, VectorViewModel vectorViewModel) {
        this.vectorLayer.addChild(new BodyVectorLayer(this.rotationModel, rotationBody, vectorViewModel));
    }

    public RotationPlatformNode getPlatformNode() {
        return this.rotationPlatformNode;
    }

    private void addRotationBodyNode(RotationBody rotationBody) {
        this.rotationBodyLayer.addChild(new RotationBodyNode(this.rotationModel, rotationBody));
    }

    public RulerNode getRulerNode() {
        return this.rulerNode;
    }

    public PNode getOriginNode() {
        return this.originNode;
    }

    public void resetAll() {
        this.rulerNode.setVisible(false);
    }
}

