/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.IgnorableEventSource;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class PInputManager
extends PBasicInputEventHandler
implements PRoot.InputSource {
    private Point2D lastCanvasPosition = new Point2D.Double();
    private Point2D currentCanvasPosition = new Point2D.Double();
    private InputEvent nextInput;
    private int nextType;
    private PCamera nextInputSource;
    private PPickPath mouseFocus;
    private PPickPath previousMouseFocus;
    private PPickPath mouseOver;
    private PPickPath previousMouseOver;
    private PInputEventListener keyboardFocus;
    private int pressedCount;

    public void setKeyboardFocus(PInputEventListener pInputEventListener) {
        PInputEvent pInputEvent = new PInputEvent(this, null);
        if (this.keyboardFocus != null) {
            this.dispatchEventToListener(pInputEvent, 1005, this.keyboardFocus);
        }
        this.keyboardFocus = pInputEventListener;
        if (this.keyboardFocus != null) {
            this.dispatchEventToListener(pInputEvent, 1004, this.keyboardFocus);
        }
    }

    public void setMouseFocus(PPickPath pPickPath) {
        this.previousMouseFocus = this.mouseFocus;
        this.mouseFocus = pPickPath;
    }

    public PPickPath getMouseOver() {
        return this.mouseOver;
    }

    public void setMouseOver(PPickPath pPickPath) {
        this.mouseOver = pPickPath;
    }

    public Point2D getLastCanvasPosition() {
        return this.lastCanvasPosition;
    }

    public Point2D getCurrentCanvasPosition() {
        return this.currentCanvasPosition;
    }

    public void keyPressed(PInputEvent pInputEvent) {
        this.dispatchEventToListener(pInputEvent, 401, this.keyboardFocus);
    }

    public void keyReleased(PInputEvent pInputEvent) {
        this.dispatchEventToListener(pInputEvent, 402, this.keyboardFocus);
    }

    public void keyTyped(PInputEvent pInputEvent) {
        this.dispatchEventToListener(pInputEvent, 400, this.keyboardFocus);
    }

    public void mouseClicked(PInputEvent pInputEvent) {
        this.dispatchEventToListener(pInputEvent, 500, this.previousMouseFocus);
    }

    public void mouseWheelRotated(PInputEvent pInputEvent) {
        this.setMouseFocus(this.getMouseOver());
        this.dispatchEventToListener(pInputEvent, 0, this.mouseOver);
    }

    public void mouseWheelRotatedByBlock(PInputEvent pInputEvent) {
        this.setMouseFocus(this.getMouseOver());
        this.dispatchEventToListener(pInputEvent, 1, this.mouseOver);
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        this.checkForMouseEnteredAndExited(pInputEvent);
        this.dispatchEventToListener(pInputEvent, 506, this.mouseFocus);
    }

    public void mouseEntered(PInputEvent pInputEvent) {
        this.dispatchEventToListener(pInputEvent, 504, this.mouseOver);
    }

    public void mouseExited(PInputEvent pInputEvent) {
        this.dispatchEventToListener(pInputEvent, 505, this.previousMouseOver);
    }

    public void mouseMoved(PInputEvent pInputEvent) {
        this.checkForMouseEnteredAndExited(pInputEvent);
        this.dispatchEventToListener(pInputEvent, 503, this.mouseOver);
    }

    public void mousePressed(PInputEvent pInputEvent) {
        if (this.pressedCount == 0) {
            this.setMouseFocus(this.getMouseOver());
        }
        ++this.pressedCount;
        this.dispatchEventToListener(pInputEvent, 501, this.mouseFocus);
        if (this.pressedCount < 1 || this.pressedCount > 3) {
            System.err.println("invalid pressedCount on mouse pressed: " + this.pressedCount);
        }
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        --this.pressedCount;
        this.checkForMouseEnteredAndExited(pInputEvent);
        this.dispatchEventToListener(pInputEvent, 502, this.mouseFocus);
        if (this.pressedCount == 0) {
            this.setMouseFocus(null);
        }
        if (this.pressedCount < 0 || this.pressedCount > 2) {
            System.err.println("invalid pressedCount on mouse released: " + this.pressedCount);
        }
    }

    protected void checkForMouseEnteredAndExited(PInputEvent pInputEvent) {
        PNode pNode;
        PNode pNode2 = this.mouseOver != null ? this.mouseOver.getPickedNode() : null;
        PNode pNode3 = pNode = this.previousMouseOver != null ? this.previousMouseOver.getPickedNode() : null;
        if (pNode2 != pNode) {
            this.dispatchEventToListener(pInputEvent, 505, this.previousMouseOver);
            this.dispatchEventToListener(pInputEvent, 504, this.mouseOver);
            this.previousMouseOver = this.mouseOver;
        }
    }

    public void processInput() {
        Object object;
        if (this.nextInput == null) {
            return;
        }
        if (this.nextInput.getSource() instanceof IgnorableEventSource && (object = (IgnorableEventSource)this.nextInput.getSource()).isIgnoringEvents()) {
            return;
        }
        object = new PInputEvent(this, this.nextInput);
        Point2D point2D = null;
        Point2D point2D2 = null;
        if (((PInputEvent)object).isMouseEvent()) {
            if (((PInputEvent)object).isMouseEnteredOrMouseExited()) {
                PPickPath pPickPath = this.nextInputSource.pick(((MouseEvent)this.nextInput).getX(), ((MouseEvent)this.nextInput).getY(), 1.0);
                this.setMouseOver(pPickPath);
                this.previousMouseOver = pPickPath;
                point2D = (Point2D)this.currentCanvasPosition.clone();
                point2D2 = (Point2D)this.lastCanvasPosition.clone();
            } else {
                this.lastCanvasPosition.setLocation(this.currentCanvasPosition);
                this.currentCanvasPosition.setLocation(((MouseEvent)this.nextInput).getX(), ((MouseEvent)this.nextInput).getY());
                PPickPath pPickPath = this.nextInputSource.pick(this.currentCanvasPosition.getX(), this.currentCanvasPosition.getY(), 1.0);
                this.setMouseOver(pPickPath);
            }
        }
        this.nextInput = null;
        this.nextInputSource = null;
        this.processEvent((PInputEvent)object, this.nextType);
        if (point2D != null && point2D2 != null) {
            this.currentCanvasPosition.setLocation(point2D);
            this.lastCanvasPosition.setLocation(point2D2);
        }
    }

    public void processEventFromCamera(InputEvent inputEvent, int n, PCamera pCamera) {
        this.nextInput = inputEvent;
        this.nextType = n;
        this.nextInputSource = pCamera;
        pCamera.getRoot().processInputs();
    }

    private void dispatchEventToListener(PInputEvent pInputEvent, int n, PInputEventListener pInputEventListener) {
        if (pInputEventListener != null) {
            pInputEvent.setHandled(false);
            pInputEventListener.processEvent(pInputEvent, n);
        }
    }
}

