/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.pswing;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import edu.umd.cs.piccolox.pswing.PSwingMouseEvent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.swing.SwingUtilities;

public class PSwingEventHandler
implements PInputEventListener {
    private PNode listenNode = null;
    private boolean active = false;
    private Component prevComponent = null;
    private Point2D prevPoint = null;
    private Point2D prevOff = null;
    private boolean recursing = false;
    private ButtonData leftButtonData = new ButtonData();
    private ButtonData rightButtonData = new ButtonData();
    private ButtonData middleButtonData = new ButtonData();
    private PSwingCanvas canvas;

    public PSwingEventHandler(PSwingCanvas pSwingCanvas, PNode pNode) {
        this.canvas = pSwingCanvas;
        this.listenNode = pNode;
    }

    void setActive(boolean bl) {
        if (this.active && !bl) {
            if (this.listenNode != null) {
                this.active = false;
                this.listenNode.removeInputEventListener(this);
            }
        } else if (!this.active && bl && this.listenNode != null) {
            this.active = true;
            this.listenNode.addInputEventListener(this);
        }
    }

    private Component findShowingComponentAt(Component component, int n, int n2) {
        if (!component.contains(n, n2)) {
            return null;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n3 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < n3; ++i) {
                Component component2 = componentArray[i];
                if (component2 == null) continue;
                Point point = component2.getLocation();
                if ((component2 = component2 instanceof Container ? this.findShowingComponentAt(component2, n - (int)point.getX(), n2 - (int)point.getY()) : component2.getComponentAt(n - (int)point.getX(), n2 - (int)point.getY())) == null || !component2.isShowing()) continue;
                return component2;
            }
        }
        return component;
    }

    void dispatchEvent(PSwingMouseEvent pSwingMouseEvent, PInputEvent pInputEvent) {
        Serializable serializable;
        Serializable serializable2;
        Component component = null;
        Point2D.Double double_ = null;
        PNode pNode = pSwingMouseEvent.getPath().getPickedNode();
        int n = 0;
        int n2 = 0;
        PNode pNode2 = pSwingMouseEvent.getCurrentNode();
        if (pNode2 instanceof PSwing) {
            serializable2 = (PSwing)pNode2;
            serializable = pNode;
            if (serializable.isDescendentOf(this.canvas.getRoot())) {
                double_ = new Point2D.Double(pSwingMouseEvent.getX(), pSwingMouseEvent.getY());
                this.cameraToLocal(pSwingMouseEvent.getPath().getTopCamera(), double_, (PNode)serializable);
                this.prevPoint = new Point2D.Double(((Point2D)double_).getX(), ((Point2D)double_).getY());
                component = this.findShowingComponentAt(((PSwing)serializable2).getComponent(), (int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
                if (component != null && component != ((PSwing)serializable2).getComponent()) {
                    for (Component component2 = component; component2 != ((PSwing)serializable2).getComponent(); component2 = component2.getParent()) {
                        n = (int)((double)n + component2.getLocation().getX());
                        n2 = (int)((double)n2 + component2.getLocation().getY());
                    }
                }
                if (component != null && pSwingMouseEvent.getID() == 501) {
                    if (SwingUtilities.isLeftMouseButton(pSwingMouseEvent)) {
                        this.leftButtonData.setState((PSwing)serializable2, pNode, component, n, n2);
                    } else if (SwingUtilities.isMiddleMouseButton(pSwingMouseEvent)) {
                        this.middleButtonData.setState((PSwing)serializable2, pNode, component, n, n2);
                    } else if (SwingUtilities.isRightMouseButton(pSwingMouseEvent)) {
                        this.rightButtonData.setState((PSwing)serializable2, pNode, component, n, n2);
                    }
                }
            }
        }
        if (pSwingMouseEvent.getID() == 506 || pSwingMouseEvent.getID() == 502) {
            if (SwingUtilities.isLeftMouseButton(pSwingMouseEvent) && this.leftButtonData.getFocusedComponent() != null) {
                this.handleButton(pSwingMouseEvent, pInputEvent, this.leftButtonData);
            }
            if (SwingUtilities.isMiddleMouseButton(pSwingMouseEvent) && this.middleButtonData.getFocusedComponent() != null) {
                this.handleButton(pSwingMouseEvent, pInputEvent, this.middleButtonData);
            }
            if (SwingUtilities.isRightMouseButton(pSwingMouseEvent) && this.rightButtonData.getFocusedComponent() != null) {
                this.handleButton(pSwingMouseEvent, pInputEvent, this.rightButtonData);
            }
        } else if ((pSwingMouseEvent.getID() == 501 || pSwingMouseEvent.getID() == 500 || pSwingMouseEvent.getID() == 503) && component != null) {
            serializable2 = new MouseEvent(component, pSwingMouseEvent.getID(), pSwingMouseEvent.getWhen(), pSwingMouseEvent.getModifiers(), (int)((Point2D)double_).getX() - n, (int)((Point2D)double_).getY() - n2, pSwingMouseEvent.getClickCount(), pSwingMouseEvent.isPopupTrigger());
            serializable = PSwingMouseEvent.createMouseEvent(((AWTEvent)serializable2).getID(), (MouseEvent)serializable2, pInputEvent);
            this.dispatchEvent(component, (PSwingMouseEvent)serializable);
            pSwingMouseEvent.consume();
        }
        if (this.prevComponent != null) {
            if (component == null || pSwingMouseEvent.getID() == 505) {
                serializable2 = this.createExitEvent(pSwingMouseEvent);
                serializable = PSwingMouseEvent.createMouseEvent(((AWTEvent)serializable2).getID(), (MouseEvent)serializable2, pInputEvent);
                this.dispatchEvent(this.prevComponent, (PSwingMouseEvent)serializable);
                this.prevComponent = null;
                if (pSwingMouseEvent.getID() == 505) {
                    pSwingMouseEvent.consume();
                }
            } else if (this.prevComponent != component) {
                serializable2 = this.createExitEvent(pSwingMouseEvent);
                serializable = PSwingMouseEvent.createMouseEvent(((AWTEvent)serializable2).getID(), (MouseEvent)serializable2, pInputEvent);
                this.dispatchEvent(this.prevComponent, (PSwingMouseEvent)serializable);
                serializable2 = this.createEnterEvent(component, pSwingMouseEvent, n, n2);
                serializable = PSwingMouseEvent.createMouseEvent(((AWTEvent)serializable2).getID(), (MouseEvent)serializable2, pInputEvent);
                component.dispatchEvent((AWTEvent)serializable);
            }
        } else if (component != null) {
            serializable2 = this.createEnterEvent(component, pSwingMouseEvent, n, n2);
            serializable = PSwingMouseEvent.createMouseEvent(((AWTEvent)serializable2).getID(), (MouseEvent)serializable2, pInputEvent);
            this.dispatchEvent(component, (PSwingMouseEvent)serializable);
        }
        this.prevComponent = component;
        if (component != null) {
            this.prevOff = new Point2D.Double(n, n2);
        }
    }

    private MouseEvent createEnterEvent(Component component, PSwingMouseEvent pSwingMouseEvent, int n, int n2) {
        return new MouseEvent(component, 504, pSwingMouseEvent.getWhen(), 0, (int)this.prevPoint.getX() - n, (int)this.prevPoint.getY() - n2, pSwingMouseEvent.getClickCount(), pSwingMouseEvent.isPopupTrigger());
    }

    private MouseEvent createExitEvent(PSwingMouseEvent pSwingMouseEvent) {
        return new MouseEvent(this.prevComponent, 505, pSwingMouseEvent.getWhen(), 0, (int)this.prevPoint.getX() - (int)this.prevOff.getX(), (int)this.prevPoint.getY() - (int)this.prevOff.getY(), pSwingMouseEvent.getClickCount(), pSwingMouseEvent.isPopupTrigger());
    }

    private void handleButton(PSwingMouseEvent pSwingMouseEvent, PInputEvent pInputEvent, ButtonData buttonData) {
        if (buttonData.getPNode().isDescendentOf(this.canvas.getRoot())) {
            Point2D.Double double_ = new Point2D.Double(pSwingMouseEvent.getX(), pSwingMouseEvent.getY());
            this.cameraToLocal(pSwingMouseEvent.getPath().getTopCamera(), double_, buttonData.getPNode());
            MouseEvent mouseEvent = new MouseEvent(buttonData.getFocusedComponent(), pSwingMouseEvent.getID(), pSwingMouseEvent.getWhen(), pSwingMouseEvent.getModifiers(), (int)((Point2D)double_).getX() - buttonData.getOffsetX(), (int)((Point2D)double_).getY() - buttonData.getOffsetY(), pSwingMouseEvent.getClickCount(), pSwingMouseEvent.isPopupTrigger());
            PSwingMouseEvent pSwingMouseEvent2 = PSwingMouseEvent.createMouseEvent(mouseEvent.getID(), mouseEvent, pInputEvent);
            this.dispatchEvent(buttonData.getFocusedComponent(), pSwingMouseEvent2);
        } else {
            this.dispatchEvent(buttonData.getFocusedComponent(), pSwingMouseEvent);
        }
        pSwingMouseEvent.consume();
        if (pSwingMouseEvent.getID() == 502) {
            buttonData.mouseReleased();
        }
    }

    private void dispatchEvent(final Component component, final PSwingMouseEvent pSwingMouseEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PSwingEventHandler.this.canvas.setIgnoringEvents(true);
                component.dispatchEvent(pSwingMouseEvent);
                PSwingEventHandler.this.canvas.setIgnoringEvents(false);
            }
        });
    }

    private void cameraToLocal(PCamera pCamera, Point2D point2D, PNode pNode) {
        AffineTransform affineTransform = null;
        try {
            affineTransform = pCamera.getViewTransform().createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        PNode pNode2 = pNode;
        do {
            if (!((pNode2 = pNode2.getParent()) instanceof PLayer)) continue;
            affineTransform.transform(point2D, point2D);
            break;
        } while (pNode2 != null);
        if (pNode != null) {
            pNode.globalToLocal(point2D);
        }
    }

    public void processEvent(PInputEvent pInputEvent, int n) {
        if (pInputEvent.isMouseEvent()) {
            InputEvent inputEvent = pInputEvent.getSourceSwingEvent();
            if (inputEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)inputEvent;
                PSwingMouseEvent pSwingMouseEvent = PSwingMouseEvent.createMouseEvent(mouseEvent.getID(), mouseEvent, pInputEvent);
                if (!this.recursing) {
                    this.recursing = true;
                    this.dispatchEvent(pSwingMouseEvent, pInputEvent);
                    this.recursing = false;
                }
            } else {
                new Exception("PInputEvent.getSourceSwingEvent was not a MouseEvent.  Actual event: " + inputEvent + ", class=" + inputEvent.getClass().getName()).printStackTrace();
            }
        }
    }

    private static class ButtonData {
        private PSwing focusPSwing = null;
        private PNode focusNode = null;
        private Component focusComponent = null;
        private int focusOffX = 0;
        private int focusOffY = 0;

        private ButtonData() {
        }

        public void setState(PSwing pSwing, PNode pNode, Component component, int n, int n2) {
            this.focusPSwing = pSwing;
            this.focusComponent = component;
            this.focusNode = pNode;
            this.focusOffX = n;
            this.focusOffY = n2;
        }

        public Component getFocusedComponent() {
            return this.focusComponent;
        }

        public PNode getPNode() {
            return this.focusNode;
        }

        public int getOffsetX() {
            return this.focusOffX;
        }

        public int getOffsetY() {
            return this.focusOffY;
        }

        public void mouseReleased() {
            this.focusComponent = null;
            this.focusNode = null;
        }
    }
}

