/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.application;

import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.resources.PhetVersionInfo;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;

public class PhetApplicationConfig {
    private String[] commandLineArgs;
    private FrameSetup frameSetup;
    private PhetResources resourceLoader;
    private final String flavor;
    private volatile PhetVersionInfo version;

    public PhetApplicationConfig(String[] stringArray, FrameSetup frameSetup, PhetResources phetResources) {
        this(stringArray, frameSetup, phetResources, phetResources.getProjectName());
    }

    public PhetApplicationConfig(String[] stringArray, FrameSetup frameSetup, PhetResources phetResources, String string) {
        if (frameSetup == null) {
            throw new NullPointerException("frameSetup is null");
        }
        if (phetResources == null) {
            throw new NullPointerException("resourceLoader is null");
        }
        if (string == null) {
            throw new NullPointerException("flavor is null");
        }
        this.commandLineArgs = stringArray;
        this.frameSetup = frameSetup;
        this.resourceLoader = phetResources;
        this.flavor = string;
    }

    public PhetVersionInfo getVersion() {
        if (this.version == null) {
            String string = this.getProjectProperty("version.major");
            String string2 = this.getProjectProperty("version.minor");
            String string3 = this.getProjectProperty("version.dev");
            String string4 = this.getProjectProperty("version.revision");
            this.version = new PhetVersionInfo(string, string2, string3, string4);
        }
        return this.version;
    }

    public String getProjectProperty(String string) {
        return this.resourceLoader.getProjectProperties().getProperty(string);
    }

    public static PhetVersionInfo getVersion(String string) {
        return new PhetApplicationConfig(new String[0], new FrameSetup.NoOp(), PhetResources.forProject(string)).getVersion();
    }
}

