/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.resources;

import edu.colorado.phet.common.phetcommon.resources.IResourceLoader;
import edu.colorado.phet.common.phetcommon.resources.PhetProperties;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

abstract class AbstractResourceLoader
implements IResourceLoader {
    AbstractResourceLoader() {
    }

    public boolean exists(String string) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(string);
        return uRL != null;
    }

    public PhetProperties getProperties(String string, Locale locale) {
        if (string == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if (string.endsWith(".properties")) {
            string = string.substring(0, string.length() - ".properties".length());
        }
        string = string.replace('/', '.');
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(string, locale);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            resourceBundle = null;
        }
        Properties properties = new Properties();
        if (resourceBundle != null) {
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                String string3 = resourceBundle.getString(string2);
                properties.put(string2, string3);
            }
        }
        return new PhetProperties(properties);
    }
}

