/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class SimStrings {
    private Vector localizedStrings;
    private Vector bundleNames;
    private Locale locale = Locale.getDefault();
    private static SimStrings INSTANCE = new SimStrings();
    private static boolean debugLocalization = false;

    public static SimStrings getInstance() {
        return INSTANCE;
    }

    public SimStrings() {
        String string = System.getProperty("javaws.phet.locale");
        if (string != null && !string.equals("")) {
            this.locale = new Locale(string);
        }
    }

    public void addStrings(String string) {
        if (this.localizedStrings == null) {
            this.localizedStrings = new Vector();
            this.bundleNames = new Vector();
        }
        if (this.bundleNames.contains(string)) {
            return;
        }
        try {
            ResourceBundle resourceBundle;
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
            if ((resourceBundle = ResourceBundle.getBundle(string, this.locale)) != null) {
                this.localizedStrings.add(resourceBundle);
                this.bundleNames.add(string);
            }
        }
        catch (Exception exception) {
            System.out.println("SimStrings.setStrings: " + exception);
        }
    }

    public String getString(String string) {
        if (debugLocalization) {
            return this.getStringDebugLocalization(string);
        }
        if (this.localizedStrings == null) {
            throw new RuntimeException("Strings not initialized");
        }
        String string2 = null;
        Iterator iterator = this.localizedStrings.iterator();
        while (string2 == null && iterator.hasNext()) {
            try {
                ResourceBundle resourceBundle = (ResourceBundle)iterator.next();
                string2 = resourceBundle.getString(string);
            }
            catch (Exception exception) {
                string2 = null;
            }
        }
        if (string2 == null) {
            System.err.println("SimStrings.get: key not found, key = \"" + string + "\"");
            string2 = string;
        }
        return string2;
    }

    private String getStringDebugLocalization(String string) {
        if (this.localizedStrings == null) {
            throw new RuntimeException("Strings not initialized");
        }
        String string2 = null;
        int n = 0;
        Iterator iterator = this.localizedStrings.iterator();
        while (string2 == null && iterator.hasNext()) {
            try {
                ResourceBundle resourceBundle = (ResourceBundle)iterator.next();
                string2 = "[" + n + "]" + resourceBundle.getString(string) + "[/" + n + "]";
            }
            catch (Exception exception) {
                string2 = null;
            }
            ++n;
        }
        if (string2 == null) {
            System.err.println("SimStrings.get: key not found, key = \"" + string + "\"");
            string2 = "[key]" + string + "[/key]";
        }
        return string2;
    }

    public static String get(String string) {
        return INSTANCE.getString(string);
    }
}

