/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_sound.application;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_sound.application.PhetApplication;
import edu.colorado.phet.common_sound.model.BaseModel;
import edu.colorado.phet.common_sound.model.clock.AbstractClock;
import edu.colorado.phet.common_sound.model.clock.ClockTickEvent;
import edu.colorado.phet.common_sound.model.clock.ClockTickListener;
import edu.colorado.phet.common_sound.view.ApparatusPanel;
import edu.colorado.phet.common_sound.view.ControlPanel;
import edu.colorado.phet.common_sound.view.help.HelpManager;
import edu.colorado.phet.common_sound.view.phetgraphics.PhetGraphic;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class Module
implements ClockTickListener {
    BaseModel model;
    ApparatusPanel apparatusPanel;
    JPanel controlPanel;
    JPanel monitorPanel;
    String name;
    private AbstractClock clock;
    HelpManager helpManager;
    private boolean helpEnabled;
    private boolean isActive;

    protected Module(String string, AbstractClock abstractClock) {
        this.name = string;
        this.clock = abstractClock;
        SimStrings.getInstance().addStrings("localization/CommonStrings");
        this.helpManager = new HelpManager();
        this.helpEnabled = false;
    }

    protected Module(String string) {
        this(string, null);
    }

    public void setApparatusPanel(ApparatusPanel apparatusPanel) {
        this.apparatusPanel = apparatusPanel;
        if (this.helpManager != null) {
            this.helpManager.setComponent(apparatusPanel);
        } else {
            this.helpManager = new HelpManager(apparatusPanel);
        }
    }

    public ApparatusPanel getApparatusPanel() {
        return this.apparatusPanel;
    }

    public void setModel(BaseModel baseModel) {
        this.model = baseModel;
    }

    public void setControlPanel(JPanel jPanel) {
        this.controlPanel = jPanel;
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public JPanel getMonitorPanel() {
        return this.monitorPanel;
    }

    public String getName() {
        return this.name;
    }

    public void addGraphic(PhetGraphic phetGraphic, double d) {
        this.getApparatusPanel().addGraphic(phetGraphic, d);
    }

    public void activate(PhetApplication phetApplication) {
        if (!this.moduleIsWellFormed()) {
            throw new RuntimeException("Module missing important data, module=" + this);
        }
        phetApplication.getPhetFrame().getBasicPhetPanel().setControlPanel(this.getControlPanel());
        phetApplication.getPhetFrame().getBasicPhetPanel().setMonitorPanel(this.getMonitorPanel());
        phetApplication.addClockTickListener(this);
        this.isActive = true;
    }

    public void deactivate(PhetApplication phetApplication) {
        phetApplication.removeClockTickListener(this);
        this.isActive = false;
    }

    public boolean moduleIsWellFormed() {
        boolean bl = true;
        bl &= this.getModel() != null;
        return bl &= this.getApparatusPanel() != null;
    }

    public String toString() {
        return "name=" + this.name + ", model=" + this.model + ", apparatusPanel=" + this.apparatusPanel + ", controlPanel=" + this.controlPanel + ", monitorPanel=" + this.monitorPanel;
    }

    public boolean hasHelp() {
        return this.helpManager.getNumGraphics() > 0;
    }

    public void setHelpEnabled(boolean bl) {
        this.helpEnabled = bl;
        this.helpManager.setHelpEnabled(this.apparatusPanel, bl);
        if (this.controlPanel instanceof ControlPanel) {
            ((ControlPanel)this.controlPanel).setHelpEnabled(bl);
        }
    }

    public boolean isHelpEnabled() {
        return this.helpEnabled;
    }

    public void addHelpItem(PhetGraphic phetGraphic) {
        this.helpManager.addGraphic(phetGraphic);
        if (this.controlPanel != null && this.controlPanel instanceof ControlPanel) {
            ((ControlPanel)this.controlPanel).setHelpPanelEnabled(true);
        }
    }

    public void showMegaHelp() {
    }

    public boolean hasMegaHelp() {
        return false;
    }

    public void updateGraphics(ClockTickEvent clockTickEvent) {
    }

    public void clockTicked(ClockTickEvent clockTickEvent) {
        this.handleUserInput();
        this.model.clockTicked(clockTickEvent);
        this.updateGraphics(clockTickEvent);
    }

    protected void handleUserInput() {
        this.getApparatusPanel().handleUserInput();
    }

    public BaseModel getModel() {
        return this.model;
    }

    public JComponent getSimulationPanel() {
        return this.getApparatusPanel();
    }
}

