/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_sound.application;

import edu.colorado.phet.common_sound.application.Module;
import edu.colorado.phet.common_sound.application.ModuleEvent;
import edu.colorado.phet.common_sound.application.ModuleObserver;
import edu.colorado.phet.common_sound.application.PhetApplication;
import edu.colorado.phet.common_sound.util.EventChannel;
import java.util.ArrayList;

public class ModuleManager {
    public static boolean USE_GZIP_STREAMS = true;
    private ArrayList modules = new ArrayList();
    private Module activeModule;
    private EventChannel moduleObserversChannel = new EventChannel(ModuleObserver.class);
    private ModuleObserver moduleObserverProxy = (ModuleObserver)this.moduleObserversChannel.getListenerProxy();
    private PhetApplication phetApplication;

    public ModuleManager() {
    }

    public ModuleManager(PhetApplication phetApplication) {
        this.phetApplication = phetApplication;
    }

    public Module moduleAt(int n) {
        return (Module)this.modules.get(n);
    }

    public Module getActiveModule() {
        return this.activeModule;
    }

    public int numModules() {
        return this.modules.size();
    }

    public void addModule(Module module) {
        this.addModule(module, false);
    }

    public boolean moduleIsWellFormed(Module module) {
        return module.moduleIsWellFormed();
    }

    public void addModule(Module module, boolean bl) {
        if (!this.moduleIsWellFormed(module)) {
            throw new RuntimeException("Module is missing something.");
        }
        this.modules.add(module);
        if (bl) {
            this.setActiveModule(module);
        }
        this.moduleObserverProxy.moduleAdded(new ModuleEvent(this, module));
    }

    public void removeModule(Module module) {
        this.modules.remove(module);
        if (this.getActiveModule() == module) {
            this.setActiveModule((Module)this.modules.get(0));
        }
        this.moduleObserverProxy.moduleRemoved(new ModuleEvent(this, module));
    }

    public void setActiveModule(int n) {
        this.setActiveModule(this.moduleAt(n));
    }

    public void setActiveModule(Module module) {
        if (this.activeModule != module) {
            this.forceSetActiveModule(module);
        }
    }

    private void forceSetActiveModule(Module module) {
        this.deactivate();
        this.activate(module);
        this.moduleObserverProxy.activeModuleChanged(new ModuleEvent(this, module));
    }

    private void activate(Module module) {
        this.activeModule = module;
        module.activate(this.phetApplication);
    }

    private void deactivate() {
        if (this.activeModule != null) {
            this.activeModule.deactivate(this.phetApplication);
        }
    }

    public void addModuleObserver(ModuleObserver moduleObserver) {
        this.moduleObserversChannel.addListener(moduleObserver);
    }

    public int indexOf(Module module) {
        return this.modules.indexOf(module);
    }

    public void addAllModules(Module[] moduleArray) {
        for (int i = 0; i < moduleArray.length; ++i) {
            this.addModule(moduleArray[i]);
        }
    }
}

