/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_sound.application;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_sound.application.Module;
import edu.colorado.phet.common_sound.application.ModuleManager;
import edu.colorado.phet.common_sound.application.ModuleObserver;
import edu.colorado.phet.common_sound.model.clock.AbstractClock;
import edu.colorado.phet.common_sound.model.clock.ClockTickListener;
import edu.colorado.phet.common_sound.view.ApparatusPanel;
import edu.colorado.phet.common_sound.view.ApparatusPanel2;
import edu.colorado.phet.common_sound.view.PhetFrame;
import edu.colorado.phet.common_sound.view.util.FrameSetup;
import edu.colorado.phet.common_sound.view.util.ImageLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class PhetApplication {
    private static PhetApplication s_instance = null;
    private PhetFrame phetFrame;
    private ModuleManager moduleManager;
    private String title;
    private Module initialModule;
    private AbstractClock clock;
    private String description;
    private String version;
    private boolean useClockControlPanel;
    private JDialog startupDlg;

    public static PhetApplication instance() {
        return s_instance;
    }

    public PhetApplication(String[] stringArray, String string, String string2, String string3, AbstractClock abstractClock, boolean bl, FrameSetup frameSetup) {
        s_instance = this;
        this.moduleManager = new ModuleManager(this);
        this.title = string;
        this.clock = abstractClock;
        this.description = string2;
        this.version = string3;
        this.useClockControlPanel = bl;
        this.createPhetFrame(frameSetup);
        this.startupDlg = new StartupDialog((Frame)this.getPhetFrame(), string);
        this.startupDlg.setVisible(true);
        this.parseArgs(stringArray);
    }

    protected void parseArgs(String[] stringArray) {
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.equals("-d")) continue;
        }
    }

    public void startApplication() {
        if (this.initialModule == null) {
            throw new RuntimeException("Initial module not specified.");
        }
        this.phetFrame.addWindowFocusListener(new WindowAdapter(){

            public void windowGainedFocus(WindowEvent windowEvent) {
                if (PhetApplication.this.startupDlg != null) {
                    PhetApplication.this.startupDlg.setVisible(false);
                    PhetApplication.this.startupDlg = null;
                }
                for (int i = 0; i < PhetApplication.this.moduleManager.numModules(); ++i) {
                    Module module = PhetApplication.this.moduleManager.moduleAt(i);
                    ApparatusPanel apparatusPanel = module.getApparatusPanel();
                    if (!(apparatusPanel instanceof ApparatusPanel2)) continue;
                    ApparatusPanel2 apparatusPanel2 = (ApparatusPanel2)apparatusPanel;
                    apparatusPanel2.setReferenceSize();
                }
                PhetApplication.this.phetFrame.removeWindowFocusListener(this);
            }
        });
        this.moduleManager.setActiveModule(this.initialModule);
        this.clock.start();
        this.phetFrame.setVisible(true);
    }

    public void createPhetFrame(FrameSetup frameSetup) {
        if (frameSetup == null) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            frameSetup = new FrameSetup.CenteredWithSize(dimension.width, dimension.height - 50);
        }
        this.phetFrame = new PhetFrame(this, this.title, this.clock, frameSetup, this.useClockControlPanel, this.moduleManager, this.description, this.version);
    }

    public PhetFrame getPhetFrame() {
        return this.phetFrame;
    }

    public AbstractClock getClock() {
        return this.clock;
    }

    public void addClockTickListener(ClockTickListener clockTickListener) {
        this.clock.addClockTickListener(clockTickListener);
    }

    public void removeClockTickListener(ClockTickListener clockTickListener) {
        this.clock.removeClockTickListener(clockTickListener);
    }

    public void setModules(Module[] moduleArray) {
        while (this.moduleManager.numModules() > 0) {
            Module module = this.moduleManager.moduleAt(0);
            this.moduleManager.removeModule(module);
        }
        this.phetFrame.setModules(moduleArray);
        this.moduleManager.addAllModules(moduleArray);
        this.phetFrame.pack();
        this.setInitialModule(moduleArray[0]);
    }

    public void setInitialModule(Module module) {
        this.initialModule = module;
    }

    public Module moduleAt(int n) {
        return this.moduleManager.moduleAt(n);
    }

    public void setActiveModule(int n) {
        this.moduleManager.setActiveModule(n);
    }

    public void addModuleObserver(ModuleObserver moduleObserver) {
        this.moduleManager.addModuleObserver(moduleObserver);
    }

    public int indexOf(Module module) {
        return this.moduleManager.indexOf(module);
    }

    private static class StartupDialog
    extends JDialog {
        private JLabel label;

        public StartupDialog(Frame frame, String string) throws HeadlessException {
            super(frame, "Startup", false);
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(3);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            String string2 = SimStrings.get("PhetApplication.StartupDialog.message");
            Object[] objectArray = new Object[]{string};
            String string3 = MessageFormat.format(string2, objectArray);
            this.label = new JLabel(string3);
            JProgressBar jProgressBar = new JProgressBar();
            jProgressBar.setIndeterminate(true);
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageLoader.loadBufferedImage("sound/images/Phet-Flatirons-logo-3-small.gif");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 20, 0, 10), 0, 0);
            gridBagConstraints.gridheight = 2;
            this.getContentPane().add((Component)new JLabel(imageIcon), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(20, 10, 10, 20);
            this.getContentPane().add((Component)this.label, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(10, 10, 20, 20);
            this.getContentPane().add((Component)jProgressBar, gridBagConstraints);
            this.pack();
            this.setLocation((int)(dimension.getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(dimension.getHeight() / 2.0 - (double)(this.getHeight() / 2)));
        }
    }
}

