/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_sound.view;

import edu.colorado.phet.common_sound.application.Module;
import edu.colorado.phet.common_sound.application.ModuleManager;
import edu.colorado.phet.common_sound.application.PhetApplication;
import edu.colorado.phet.common_sound.model.clock.AbstractClock;
import edu.colorado.phet.common_sound.view.ClockControlPanel;
import edu.colorado.phet.common_sound.view.ContentPanel;
import edu.colorado.phet.common_sound.view.TabbedApparatusPanelContainer;
import edu.colorado.phet.common_sound.view.components.menu.HelpMenu;
import edu.colorado.phet.common_sound.view.components.menu.PhetFileMenu;
import edu.colorado.phet.common_sound.view.util.FrameSetup;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;

public class PhetFrame
extends JFrame {
    private HelpMenu helpMenu;
    private JMenu defaultFileMenu;
    private boolean paused;
    private PhetApplication application;
    private ClockControlPanel clockControlPanel;
    private ContentPanel basicPhetPanel;
    private FrameSetup frameSetup;

    public PhetFrame(PhetApplication phetApplication, String string, final AbstractClock abstractClock, FrameSetup frameSetup, boolean bl, ModuleManager moduleManager, String string2, String string3) throws HeadlessException {
        super(string + " (" + string3 + ")");
        this.application = phetApplication;
        this.frameSetup = frameSetup;
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowIconified(WindowEvent windowEvent) {
                super.windowIconified(windowEvent);
                PhetFrame.this.paused = abstractClock.isPaused();
                if (!PhetFrame.this.paused) {
                    abstractClock.setPaused(true);
                }
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                super.windowDeiconified(windowEvent);
                if (!PhetFrame.this.paused) {
                    abstractClock.setPaused(false);
                }
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        this.helpMenu = new HelpMenu(this, moduleManager, string, string2, string3);
        this.defaultFileMenu = new PhetFileMenu();
        jMenuBar.add(this.defaultFileMenu);
        jMenuBar.add(this.helpMenu);
        this.setJMenuBar(jMenuBar);
        if (frameSetup != null) {
            frameSetup.initialize(this);
        }
        if (bl) {
            try {
                this.clockControlPanel = new ClockControlPanel(abstractClock);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setModules(Module[] moduleArray) {
        JComponent jComponent = this.createApparatusPanelContainer(this.application, moduleArray);
        this.basicPhetPanel = new ContentPanel(jComponent, null, null, this.clockControlPanel);
        this.setContentPane(this.basicPhetPanel);
    }

    public void pack() {
        if (this.frameSetup == null) {
            super.pack();
        }
    }

    private JComponent createApparatusPanelContainer(PhetApplication phetApplication, Module[] moduleArray) {
        JComponent jComponent = null;
        if (moduleArray.length == 1) {
            jComponent = new JPanel();
            jComponent.setLayout(new GridLayout(1, 1));
            if (moduleArray[0].getSimulationPanel() == null) {
                throw new RuntimeException("Null Apparatus Panel in Module: " + moduleArray[0].getName());
            }
            jComponent.add(moduleArray[0].getSimulationPanel());
        } else {
            jComponent = new TabbedApparatusPanelContainer(phetApplication);
        }
        return jComponent;
    }

    public ContentPanel getBasicPhetPanel() {
        return this.basicPhetPanel;
    }

    public HelpMenu getHelpMenu() {
        return this.helpMenu;
    }
}

