/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_sound.view.phetgraphics;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import java.util.Stack;

public class PhetGraphics2D
extends Graphics2D {
    private Graphics2D wrappedGraphics;
    private Stack graphicsStates = new Stack();
    private StateDescriptor currentStateDescriptor = new StateDescriptor();

    public PhetGraphics2D(Graphics2D graphics2D) {
        this.wrappedGraphics = graphics2D;
    }

    public void setBackground(Color color) {
        if (this.currentStateDescriptor.orgBackground == null) {
            this.currentStateDescriptor.orgBackground = this.getBackground();
        }
        this.wrappedGraphics.setBackground(color);
    }

    public void setComposite(Composite composite) {
        if (this.currentStateDescriptor.orgComposite == null) {
            this.currentStateDescriptor.orgComposite = this.getComposite();
        }
        this.wrappedGraphics.setComposite(composite);
    }

    public void setPaint(Paint paint) {
        if (this.currentStateDescriptor.orgPaint == null) {
            this.currentStateDescriptor.orgPaint = this.getPaint();
        }
        this.wrappedGraphics.setPaint(paint);
    }

    public void setStroke(Stroke stroke) {
        if (this.currentStateDescriptor.orgColor == null) {
            this.currentStateDescriptor.orgColor = this.getColor();
        }
        this.wrappedGraphics.setStroke(stroke);
    }

    public void setTransform(AffineTransform affineTransform) {
        if (this.currentStateDescriptor.orgTransform == null) {
            this.currentStateDescriptor.orgTransform = this.getTransform();
        }
        this.wrappedGraphics.setTransform(affineTransform);
    }

    public void addRenderingHints(Map map) {
        if (this.currentStateDescriptor.orgRenderingHints == null) {
            this.currentStateDescriptor.orgRenderingHints = this.getRenderingHints();
        }
        this.wrappedGraphics.addRenderingHints(map);
    }

    public void setRenderingHints(Map map) {
        if (this.currentStateDescriptor.orgRenderingHints == null) {
            this.currentStateDescriptor.orgRenderingHints = this.getRenderingHints();
        }
        this.wrappedGraphics.setRenderingHints(map);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.currentStateDescriptor.orgRenderingHints == null) {
            this.currentStateDescriptor.orgRenderingHints = this.getRenderingHints();
        }
        this.wrappedGraphics.setRenderingHint(key, object);
    }

    public void setPaintMode() {
        this.wrappedGraphics.setPaintMode();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        if (this.currentStateDescriptor.orgClip == null) {
            this.currentStateDescriptor.orgClip = this.getClip();
        }
        this.wrappedGraphics.clipRect(n, n2, n3, n4);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        if (this.currentStateDescriptor.orgClip == null) {
            this.currentStateDescriptor.orgClip = this.getClip();
        }
        this.wrappedGraphics.setClip(n, n2, n3, n4);
    }

    public void setColor(Color color) {
        if (this.currentStateDescriptor.orgColor == null) {
            this.currentStateDescriptor.orgColor = this.getColor();
        }
        this.wrappedGraphics.setColor(color);
    }

    public void setXORMode(Color color) {
        this.wrappedGraphics.setXORMode(color);
    }

    public void setFont(Font font) {
        if (this.currentStateDescriptor.orgFont == null) {
            this.currentStateDescriptor.orgFont = this.getFont();
        }
        this.wrappedGraphics.setFont(font);
    }

    public void setClip(Shape shape) {
        if (this.currentStateDescriptor.orgClip == null) {
            this.currentStateDescriptor.orgClip = this.getClip();
        }
        this.wrappedGraphics.setClip(shape);
    }

    public void rotate(double d) {
        if (this.currentStateDescriptor.orgTransform == null) {
            this.currentStateDescriptor.orgTransform = this.getTransform();
        }
        this.wrappedGraphics.rotate(d);
    }

    public void scale(double d, double d2) {
        if (this.currentStateDescriptor.orgTransform == null) {
            this.currentStateDescriptor.orgTransform = this.getTransform();
        }
        this.wrappedGraphics.scale(d, d2);
    }

    public void shear(double d, double d2) {
        if (this.currentStateDescriptor.orgTransform == null) {
            this.currentStateDescriptor.orgTransform = this.getTransform();
        }
        this.wrappedGraphics.shear(d, d2);
    }

    public void translate(double d, double d2) {
        if (this.currentStateDescriptor.orgTransform == null) {
            this.currentStateDescriptor.orgTransform = this.getTransform();
        }
        this.wrappedGraphics.translate(d, d2);
    }

    public void rotate(double d, double d2, double d3) {
        if (this.currentStateDescriptor.orgTransform == null) {
            this.currentStateDescriptor.orgTransform = this.getTransform();
        }
        this.wrappedGraphics.rotate(d, d2, d3);
    }

    public void translate(int n, int n2) {
        if (this.currentStateDescriptor.orgTransform == null) {
            this.currentStateDescriptor.orgTransform = this.getTransform();
        }
        this.wrappedGraphics.translate(n, n2);
    }

    public void transform(AffineTransform affineTransform) {
        if (this.currentStateDescriptor.orgTransform == null) {
            this.currentStateDescriptor.orgTransform = this.getTransform();
        }
        this.wrappedGraphics.transform(affineTransform);
    }

    public Color getBackground() {
        return this.wrappedGraphics.getBackground();
    }

    public Composite getComposite() {
        return this.wrappedGraphics.getComposite();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.wrappedGraphics.getDeviceConfiguration();
    }

    public Paint getPaint() {
        return this.wrappedGraphics.getPaint();
    }

    public RenderingHints getRenderingHints() {
        return this.wrappedGraphics.getRenderingHints();
    }

    public void draw(Shape shape) {
        this.wrappedGraphics.draw(shape);
    }

    public void fill(Shape shape) {
        this.wrappedGraphics.fill(shape);
    }

    public Stroke getStroke() {
        return this.wrappedGraphics.getStroke();
    }

    public FontRenderContext getFontRenderContext() {
        return this.wrappedGraphics.getFontRenderContext();
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.wrappedGraphics.drawGlyphVector(glyphVector, f, f2);
    }

    public AffineTransform getTransform() {
        return this.wrappedGraphics.getTransform();
    }

    public void drawString(String string, float f, float f2) {
        this.wrappedGraphics.drawString(string, f, f2);
    }

    public void drawString(String string, int n, int n2) {
        this.wrappedGraphics.drawString(string, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.wrappedGraphics.drawString(attributedCharacterIterator, f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.wrappedGraphics.drawString(attributedCharacterIterator, n, n2);
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.wrappedGraphics.hit(rectangle, shape, bl);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.wrappedGraphics.drawRenderedImage(renderedImage, affineTransform);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.wrappedGraphics.drawRenderableImage(renderableImage, affineTransform);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.wrappedGraphics.drawImage(bufferedImage, bufferedImageOp, n, n2);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.wrappedGraphics.getRenderingHint(key);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.wrappedGraphics.drawImage(image, affineTransform, imageObserver);
    }

    public void dispose() {
        this.wrappedGraphics.dispose();
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.wrappedGraphics.clearRect(n, n2, n3, n4);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.wrappedGraphics.drawLine(n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.wrappedGraphics.drawOval(n, n2, n3, n4);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.wrappedGraphics.fillOval(n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.wrappedGraphics.fillRect(n, n2, n3, n4);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.wrappedGraphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.wrappedGraphics.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.wrappedGraphics.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.wrappedGraphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.wrappedGraphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.wrappedGraphics.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.wrappedGraphics.drawPolyline(nArray, nArray2, n);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.wrappedGraphics.fillPolygon(nArray, nArray2, n);
    }

    public Color getColor() {
        return this.wrappedGraphics.getColor();
    }

    public Font getFont() {
        return this.wrappedGraphics.getFont();
    }

    public Graphics create() {
        return this.wrappedGraphics.create();
    }

    public Rectangle getClipBounds() {
        return this.wrappedGraphics.getClipBounds();
    }

    public Shape getClip() {
        return this.wrappedGraphics.getClip();
    }

    public void clip(Shape shape) {
        this.wrappedGraphics.clip(shape);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.wrappedGraphics.getFontMetrics(font);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.wrappedGraphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.wrappedGraphics.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.wrappedGraphics.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.wrappedGraphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.wrappedGraphics.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.wrappedGraphics.drawImage(image, n, n2, color, imageObserver);
    }

    private class StateDescriptor {
        Font orgFont;
        RenderingHints orgRenderingHints;
        Shape orgClip;
        Color orgBackground;
        Color orgColor;
        Paint orgPaint;
        Composite orgComposite;
        AffineTransform orgTransform;

        private StateDescriptor() {
        }
    }
}

