/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_sound.view.phetgraphics;

import edu.colorado.phet.common_sound.view.phetgraphics.PhetGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class PhetTextGraphic
extends PhetGraphic {
    private Font font;
    private String text = "";
    private Color color;
    private FontMetrics fontMetrics;
    private int justification = 1;

    public PhetTextGraphic(Component component, Font font, String string, Color color) {
        this(component, font, string, color, 0, 0);
    }

    public PhetTextGraphic(Component component, Font font, String string, Color color, int n, int n2) {
        super(component);
        this.setFont(font);
        this.text = string;
        this.color = color;
        this.fontMetrics = component.getFontMetrics(font);
        this.resetRegistrationPoint();
        this.setLocation(n, n2);
    }

    public void setJustification(int n) {
        this.justification = n;
        int n2 = this.fontMetrics.getAscent();
        Point point = new Point();
        switch (n) {
            case 1: {
                point.setLocation(0, -n2);
                break;
            }
            case 2: {
                point.setLocation((int)(this.getBounds().getWidth() / 2.0), -n2);
                break;
            }
            case 3: {
                point.setLocation((int)this.getBounds().getWidth(), -n2);
                break;
            }
            case 4: {
                point.setLocation((int)this.getBounds().getWidth(), -this.getHeight() + n2 / 2);
                break;
            }
            case 5: {
                point.setLocation((int)this.getBounds().getWidth(), -this.getHeight() + n2);
                break;
            }
            case 6: {
                point.setLocation((int)(this.getBounds().getWidth() / 2.0), -this.getHeight() + n2);
                break;
            }
            case 7: {
                point.setLocation(0, -this.getHeight() + n2);
                break;
            }
            case 8: {
                point.setLocation(0, -this.getHeight() + n2 / 2);
                break;
            }
            case 9: {
                point.setLocation((int)(this.getBounds().getWidth() / 2.0), -this.getHeight() + n2 / 2);
                break;
            }
            default: {
                throw new RuntimeException("Invalid justification specified");
            }
        }
        this.setRegistrationPoint(point);
    }

    public void setColor(Color color) {
        this.color = color;
        this.setBoundsDirty();
        this.autorepaint();
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = this.getComponent().getFontMetrics(font);
        this.setBoundsDirty();
        this.setJustification(this.justification);
        this.autorepaint();
    }

    private void resetRegistrationPoint() {
        this.setRegistrationPoint(0, -this.fontMetrics.getAscent());
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.saveGraphicsState(graphics2D);
            super.updateGraphicsState(graphics2D);
            graphics2D.setFont(this.font);
            graphics2D.setColor(this.color);
            graphics2D.transform(this.getNetTransform());
            int n = this.fontMetrics.getDescent();
            graphics2D.drawString(this.text, 0, -n);
            super.restoreGraphicsState();
        }
    }

    protected Rectangle determineBounds() {
        if (this.text == null || this.text.equals("")) {
            return null;
        }
        int n = this.fontMetrics.stringWidth(this.text);
        int n2 = this.fontMetrics.getHeight();
        Rectangle rectangle = new Rectangle(0, -n2, n, n2);
        return this.getNetTransform().createTransformedShape(rectangle).getBounds();
    }

    public PhetTextGraphic() {
    }
}

