/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common_sound.view.util;

import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

public class ImageLoader {
    LoadStrategy loadStrategy;
    ConversionStrategy conversionStrategy;
    public static final ImageLoader instance = new ImageLoader();

    public static BufferedImage loadBufferedImage(String string) throws IOException {
        return instance.loadImage(string);
    }

    public ImageLoader() {
        this.setPhetLoader();
        this.conversionStrategy = new ConversionStrategy(){

            public BufferedImage toBufferedImage(Image image) {
                return BufferedImageUtils.toBufferedImage(image);
            }
        };
    }

    public BufferedImage loadImage(String string) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            throw new IOException("Null image URL for resource name=" + string);
        }
        return this.loadImage(uRL);
    }

    public BufferedImage loadImage(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IOException("Null image URL.");
        }
        Image image = this.loadStrategy.loadImage(uRL);
        BufferedImage bufferedImage = this.conversionStrategy.toBufferedImage(image);
        return bufferedImage;
    }

    public void setPhetLoader() {
        this.loadStrategy = new PhetResourceLoader();
    }

    static class PhetResourceLoader
    implements LoadStrategy {
        PhetResourceLoader() {
        }

        public Image loadImage(URL uRL) throws IOException {
            if (uRL == null) {
                throw new IOException("Null URL Location");
            }
            Image image = null;
            try {
                ResourceLoader resourceLoader = new ResourceLoader();
                image = resourceLoader.fetchImage(uRL);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return image;
        }

        private static class ResourceLoader
        extends Container {
            private ResourceLoader() {
            }

            public Image fetchImage(URL uRL) throws IOException {
                Image image = null;
                try {
                    if (uRL == null) {
                        throw new IOException("Image resource not found: Null imagelocation URL");
                    }
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    image = toolkit.createImage(uRL);
                    MediaTracker mediaTracker = new MediaTracker(this);
                    mediaTracker.addImage(image, 0);
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return image;
            }
        }
    }

    static interface ConversionStrategy {
        public BufferedImage toBufferedImage(Image var1);
    }

    static interface LoadStrategy {
        public Image loadImage(URL var1) throws IOException;
    }
}

