/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_sound.application.PhetApplication;
import edu.colorado.phet.common_sound.model.clock.AbstractClock;
import edu.colorado.phet.common_sound.view.help.HelpItem;
import edu.colorado.phet.common_sound.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common_sound.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common_sound.view.util.ImageLoader;
import edu.colorado.phet.sound.SingleSourceModule;
import edu.colorado.phet.sound.SoundApplication;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.view.ClockPanelLarge;
import edu.colorado.phet.sound.view.MeasureControlPanel;
import edu.colorado.phet.sound.view.MeterStickGraphic;
import edu.colorado.phet.sound.view.VerticalGuideline;
import java.awt.Color;
import java.awt.Container;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JDialog;

public class SingleSourceMeasureModule
extends SingleSourceModule {
    private JDialog stopwatchDlg;
    private AbstractClock clock;
    private boolean closkWasPausedOnActivate;

    protected SingleSourceMeasureModule(SoundApplication soundApplication) {
        super(soundApplication, SimStrings.get("ModuleTitle.SingleSourceMeasure"));
        Object object;
        PhetGraphic phetGraphic;
        Object object2;
        this.clock = soundApplication.getClock();
        try {
            object2 = ImageLoader.loadBufferedImage("sound/images/five-meter-stick.gif");
            phetGraphic = new PhetImageGraphic(this.getApparatusPanel(), (BufferedImage)object2);
            phetGraphic.setLocation(SoundConfig.s_meterStickBaseX, SoundConfig.s_meterStickBaseY);
            object = new MeterStickGraphic(this.getApparatusPanel(), (PhetImageGraphic)phetGraphic, new Point2D.Double(SoundConfig.s_meterStickBaseX, SoundConfig.s_meterStickBaseY));
            this.addGraphic((PhetGraphic)object, 9.0);
            HelpItem helpItem = new HelpItem(this.getApparatusPanel(), SimStrings.get("SingleSourceMeasureModule.Help1"), SoundConfig.s_meterStickBaseX, SoundConfig.s_meterStickBaseY + ((PhetImageGraphic)phetGraphic).getImage().getHeight(), 5, 2);
            helpItem.setForegroundColor(Color.white);
            this.addHelpItem(helpItem);
            HelpItem helpItem2 = new HelpItem(this.getApparatusPanel(), SimStrings.get("SingleSourceMeasureModule.Help2"), 100.0, 70.0, 5, 1);
            helpItem2.setForegroundColor(Color.white);
            this.addHelpItem(helpItem2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object2 = new VerticalGuideline(this.getApparatusPanel(), Color.blue, 70);
        this.addGraphic((PhetGraphic)object2, 10.0);
        phetGraphic = new VerticalGuideline(this.getApparatusPanel(), Color.blue, 90);
        this.addGraphic(phetGraphic, 10.0);
        this.setControlPanel(new MeasureControlPanel(this, soundApplication.getClock()));
        this.stopwatchDlg = new JDialog(soundApplication.getPhetFrame(), "Stopwatch", false);
        object = new ClockPanelLarge(this.getModel());
        ((ClockPanelLarge)object).addListener(new StopwatchListener(this));
        this.stopwatchDlg.setContentPane((Container)object);
        this.stopwatchDlg.setLocation(0, 0);
        this.stopwatchDlg.setLocationRelativeTo(soundApplication.getPhetFrame());
        this.stopwatchDlg.setUndecorated(true);
        this.stopwatchDlg.setResizable(false);
        this.stopwatchDlg.getRootPane().setWindowDecorationStyle(2);
        this.stopwatchDlg.pack();
        this.stopwatchDlg.setDefaultCloseOperation(0);
    }

    public void activate(PhetApplication phetApplication) {
        super.activate(phetApplication);
        this.closkWasPausedOnActivate = this.clock.isPaused();
        if (!this.closkWasPausedOnActivate) {
            this.clock.setPaused(true);
        }
        this.stopwatchDlg.setVisible(true);
    }

    public void deactivate(PhetApplication phetApplication) {
        super.deactivate(phetApplication);
        this.setStopwatchVisible(false);
        if (this.clock.isPaused() != this.closkWasPausedOnActivate) {
            this.clock.setPaused(this.closkWasPausedOnActivate);
        }
    }

    public void setStopwatchVisible(boolean bl) {
        this.stopwatchDlg.setVisible(bl);
    }

    public class StopwatchListener
    implements ClockPanelLarge.ClockPanelListener {
        SingleSourceMeasureModule module;

        public StopwatchListener(SingleSourceMeasureModule singleSourceMeasureModule2) {
            this.module = singleSourceMeasureModule2;
        }

        public void clockPaneEventOccurred(ClockPanelLarge.ClockPanelEvent clockPanelEvent) {
            if (clockPanelEvent.isReset()) {
                this.module.resetWaveMediumGraphic();
                if (!SingleSourceMeasureModule.this.clock.isPaused()) {
                    SingleSourceMeasureModule.this.clock.setPaused(true);
                }
                SingleSourceMeasureModule.this.clock.tickOnce();
                SingleSourceMeasureModule.this.clock.tickOnce();
            } else if (clockPanelEvent.isRunning() && SingleSourceMeasureModule.this.clock.isPaused()) {
                SingleSourceMeasureModule.this.clock.setPaused(false);
            } else if (!SingleSourceMeasureModule.this.clock.isPaused()) {
                SingleSourceMeasureModule.this.clock.setPaused(true);
            }
        }
    }
}

