/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.sound.SoundApplication;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.SoundModule;
import edu.colorado.phet.sound.model.SoundModel;
import edu.colorado.phet.sound.model.WaveMedium;
import edu.colorado.phet.sound.model.Wavefront;
import edu.colorado.phet.sound.view.SingleSourceApparatusPanel;
import edu.colorado.phet.sound.view.SoundControlPanel;
import edu.colorado.phet.sound.view.WaveMediumGraphic;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class SingleSourceModule
extends SoundModule {
    private WaveMedium waveMedium;

    protected SingleSourceModule(SoundApplication soundApplication, String string) {
        super(soundApplication, string);
        SingleSourceApparatusPanel singleSourceApparatusPanel = new SingleSourceApparatusPanel((SoundModel)this.getModel(), soundApplication.getClock());
        this.setApparatusPanel(singleSourceApparatusPanel);
        this.waveMedium = ((SoundModel)this.getModel()).getWaveMedium();
        WaveMediumGraphic waveMediumGraphic = new WaveMediumGraphic(this.waveMedium, this.getApparatusPanel(), this);
        this.addGraphic(waveMediumGraphic, 7.0);
        Point2D.Double double_ = new Point2D.Double(SoundConfig.s_wavefrontBaseX, SoundConfig.s_wavefrontBaseY);
        waveMediumGraphic.initLayout(double_, SoundConfig.s_wavefrontHeight, SoundConfig.s_wavefrontRadius);
        this.setControlPanel(new SoundControlPanel(this));
    }

    protected void resetWaveMediumGraphic() {
        ArrayList arrayList = this.waveMedium.getWavefronts();
        for (int i = 0; i < arrayList.size(); ++i) {
            Wavefront wavefront = (Wavefront)arrayList.get(i);
            wavefront.clear();
        }
    }
}

