/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_sound.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.coreadditions_sound.ScalarObservable;
import edu.colorado.phet.sound.SingleSourceListenModule;
import edu.colorado.phet.sound.SoundApplication;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.model.AttenuationFunction;
import edu.colorado.phet.sound.model.SoundModel;
import edu.colorado.phet.sound.model.WaveMedium;
import edu.colorado.phet.sound.view.DialGauge;
import edu.colorado.phet.sound.view.SoundControlPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SingleSourceWithBoxModule
extends SingleSourceListenModule {
    private AirBoxGraphic boxInteriorGraphic;
    private PhetShapeGraphic boxGraphic;
    private double airDensity;
    private ScalarObservable airDensityObservable;
    private DialGauge pressureGauge;
    final int maxDensity = 200;

    protected SingleSourceWithBoxModule(SoundApplication soundApplication) {
        super(soundApplication, SimStrings.get("ModuleTitle.SingelSourceWithBox"));
        this.init();
    }

    private void init() {
        this.getSpeakerListener().setLocation(new Point2D.Double(10.0, 0.0));
        this.airDensityObservable = new ScalarObservable(){

            public double getValue() {
                return SingleSourceWithBoxModule.this.airDensity;
            }
        };
        double d = 150.0;
        double d2 = 80.0;
        double d3 = 100.0;
        this.pressureGauge = new DialGauge(this.airDensityObservable, this.getApparatusPanel(), d, d2, d3, 0.0, 1.0, SimStrings.get("SingleSourceWithBoxModule.Pressure"), SimStrings.get("SingleSourceWithBoxModule.ATM"));
        Rectangle2D.Double double_ = new Rectangle2D.Double(d - 5.0, d2 + d3 / 2.0, 10.0, 20.0);
        this.pressureGauge.addGraphic(new PhetShapeGraphic(this.getApparatusPanel(), double_, Color.black), 6.0);
        SoundModel soundModel = (SoundModel)this.getModel();
        WaveMedium waveMedium = soundModel.getWaveMedium();
        Shape shape = this.createBox();
        VariableWaveMediumAttenuationFunction variableWaveMediumAttenuationFunction = new VariableWaveMediumAttenuationFunction();
        variableWaveMediumAttenuationFunction.setVariableRegion(shape);
        waveMedium.setAttenuationFunction(variableWaveMediumAttenuationFunction);
        this.boxGraphic = new PhetShapeGraphic(this.getApparatusPanel(), shape, new BasicStroke(8.0f), new Color(124, 80, 10));
        this.boxInteriorGraphic = new AirBoxGraphic(this.getApparatusPanel(), shape);
        this.getApparatusPanel().addGraphic(this.boxGraphic, 8.0);
        this.getApparatusPanel().addGraphic(this.boxInteriorGraphic, 6.0);
        this.getApparatusPanel().addGraphic(this.pressureGauge, 5.0);
        SoundControlPanel soundControlPanel = (SoundControlPanel)this.getControlPanel();
        soundControlPanel.addPanel(new BoxAirDensityControlPanel(variableWaveMediumAttenuationFunction));
        this.getAudioControlPanel().setAudioSource(2);
        this.getListenerGraphic().setMovable(false);
    }

    private Shape createBox() {
        int n = 180;
        int n2 = 350;
        float f = 50.0f;
        GeneralPath generalPath = new GeneralPath();
        float f2 = (float)SoundConfig.s_wavefrontBaseX - f;
        float f3 = SoundConfig.s_wavefrontBaseY - n2 / 2;
        double d = Math.atan((float)(n2 / 2) / ((float)n - f));
        float f4 = (float)((double)n + (double)(n2 / 2) * Math.tan(d));
        generalPath.moveTo(f2, f3);
        generalPath.lineTo(f2 + (float)n, f3);
        generalPath.quadTo(f2 + f4 * 0.85f, SoundConfig.s_wavefrontBaseY, f2 + (float)n, f3 + (float)n2);
        generalPath.lineTo(f2, f3 + (float)n2);
        generalPath.closePath();
        return generalPath;
    }

    public int rgbAt(int n, int n2) {
        if (this.boxInteriorGraphic.contains(SoundConfig.s_wavefrontBaseX + 80 + n, SoundConfig.s_wavefrontBaseY + n2)) {
            return this.boxInteriorGraphic.getGrayLevel();
        }
        return super.rgbAt(n, n2);
    }

    public void setAudioSource(int n) {
        super.setAudioSource(n);
    }

    private class VariableWaveMediumAttenuationFunction
    implements AttenuationFunction {
        private Shape variableRegion;
        private double variableRegionAttenuation = 1.0;

        private VariableWaveMediumAttenuationFunction() {
        }

        public void setVariableRegion(Shape shape) {
            this.variableRegion = shape;
        }

        public void setVariableRegionAttenuation(double d) {
            this.variableRegionAttenuation = Math.sqrt(1.0 - (d - 1.0) * (d - 1.0));
        }

        public double getAttenuation(double d, double d2) {
            if (this.variableRegion != null && this.variableRegion.contains(d + (double)SoundConfig.s_speakerBaseX, d2 + 201.0)) {
                return this.variableRegionAttenuation;
            }
            return 1.0;
        }
    }

    private class BoxAirDensityControlPanel
    extends JPanel {
        VariableWaveMediumAttenuationFunction attenuationFunction;
        String evacuateLabel = SimStrings.get("SingleSourceWithBoxModule.RemoveAir");
        String addLabel = SimStrings.get("SingleSourceWithBoxModule.AddAir");
        boolean evacuateToggle = true;
        private JButton airButton;
        private JSlider densitySlider;
        private BoxEvacuator boxEvacuator;
        private Color airButtonEnabledBackground;

        public BoxAirDensityControlPanel(VariableWaveMediumAttenuationFunction variableWaveMediumAttenuationFunction) {
            this.attenuationFunction = variableWaveMediumAttenuationFunction;
            this.airButton = new JButton(this.evacuateLabel);
            this.airButton.addActionListener(new ActionListener(this, SingleSourceWithBoxModule.this){
                private final /* synthetic */ SingleSourceWithBoxModule val$this$0;
                private final /* synthetic */ BoxAirDensityControlPanel this$1;
                {
                    this.this$1 = boxAirDensityControlPanel;
                    this.val$this$0 = singleSourceWithBoxModule;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    BoxAirDensityControlPanel.access$202(this.this$1, this.this$1.new BoxEvacuator());
                    BoxAirDensityControlPanel.access$200(this.this$1).start();
                }
            });
            this.densitySlider = new JSlider(0, 0, 200, 200);
            this.densitySlider.setSnapToTicks(true);
            this.densitySlider.addChangeListener(new ChangeListener(this, variableWaveMediumAttenuationFunction){
                private final /* synthetic */ VariableWaveMediumAttenuationFunction val$attenuationFunction;
                private final /* synthetic */ BoxAirDensityControlPanel this$1;
                {
                    this.this$1 = boxAirDensityControlPanel;
                    this.val$attenuationFunction = variableWaveMediumAttenuationFunction;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    BoxAirDensityControlPanel.access$400(this.this$1, BoxAirDensityControlPanel.access$300(this.this$1), 200, this.val$attenuationFunction);
                }
            });
            this.setAirDensity(this.densitySlider, 200, variableWaveMediumAttenuationFunction);
            this.densitySlider.setEnabled(false);
            JButton jButton = new JButton(SimStrings.get("ClockPanelLarge.Reset"));
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ BoxAirDensityControlPanel this$1;
                {
                    this.this$1 = boxAirDensityControlPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (BoxAirDensityControlPanel.access$200(this.this$1) != null) {
                        BoxAirDensityControlPanel.access$200(this.this$1).kill();
                    }
                }
            });
            this.setLayout(new GridBagLayout());
            Insets insets = new Insets(0, 0, 0, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, insets, 0, 0);
            this.add((Component)this.airButton, gridBagConstraints);
            this.airButtonEnabledBackground = new Color(100, 200, 100);
            this.airButton.setBackground(this.airButtonEnabledBackground);
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 0;
            this.add((Component)jButton, gridBagConstraints);
            this.setBorder(new TitledBorder(SimStrings.get("SingleSourceWithBoxModule.BorderTitle")));
            this.setPreferredSize(new Dimension(120, 120));
        }

        private void setAirDensity(JSlider jSlider, int n, VariableWaveMediumAttenuationFunction variableWaveMediumAttenuationFunction) {
            SingleSourceWithBoxModule.this.airDensity = (double)jSlider.getValue() / (double)n;
            variableWaveMediumAttenuationFunction.setVariableRegionAttenuation(SingleSourceWithBoxModule.this.airDensity);
            SingleSourceWithBoxModule.this.boxInteriorGraphic.setAirDensity(SingleSourceWithBoxModule.this.airDensity);
            SingleSourceWithBoxModule.this.airDensityObservable.notifyObservers();
        }

        private void setAirDensity(double d, int n, VariableWaveMediumAttenuationFunction variableWaveMediumAttenuationFunction) {
            SingleSourceWithBoxModule.this.airDensity = d / 200.0;
            variableWaveMediumAttenuationFunction.setVariableRegionAttenuation(SingleSourceWithBoxModule.this.airDensity);
            SingleSourceWithBoxModule.this.boxInteriorGraphic.setAirDensity(SingleSourceWithBoxModule.this.airDensity);
            SingleSourceWithBoxModule.this.airDensityObservable.notifyObservers();
        }

        static /* synthetic */ BoxEvacuator access$202(BoxAirDensityControlPanel boxAirDensityControlPanel, BoxEvacuator boxEvacuator) {
            boxAirDensityControlPanel.boxEvacuator = boxEvacuator;
            return boxAirDensityControlPanel.boxEvacuator;
        }

        static /* synthetic */ BoxEvacuator access$200(BoxAirDensityControlPanel boxAirDensityControlPanel) {
            return boxAirDensityControlPanel.boxEvacuator;
        }

        static /* synthetic */ void access$400(BoxAirDensityControlPanel boxAirDensityControlPanel, JSlider jSlider, int n, VariableWaveMediumAttenuationFunction variableWaveMediumAttenuationFunction) {
            boxAirDensityControlPanel.setAirDensity(jSlider, n, variableWaveMediumAttenuationFunction);
        }

        class BoxEvacuator
        extends Thread {
            private int maxValue;
            private int minValue;
            private Boolean kill = Boolean.FALSE;

            BoxEvacuator() {
                this.maxValue = BoxAirDensityControlPanel.this.densitySlider.getMaximum();
                this.minValue = BoxAirDensityControlPanel.this.densitySlider.getMinimum();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.kill = Boolean.FALSE;
                try {
                    int n;
                    BoxAirDensityControlPanel.this.airButton.setEnabled(false);
                    Color color = BoxAirDensityControlPanel.this.airButton.getBackground();
                    BoxAirDensityControlPanel.this.airButton.setBackground(Color.gray);
                    int n2 = BoxAirDensityControlPanel.this.evacuateToggle ? -1 : 1;
                    int n3 = BoxAirDensityControlPanel.this.evacuateToggle ? this.maxValue : this.minValue;
                    int n4 = n = BoxAirDensityControlPanel.this.evacuateToggle ? this.minValue : this.maxValue;
                    while (n3 != n) {
                        BoxAirDensityControlPanel.this.densitySlider.setValue(n3 += n2);
                        BoxAirDensityControlPanel.this.setAirDensity(n3, this.maxValue, BoxAirDensityControlPanel.this.attenuationFunction);
                        Thread.sleep(100L);
                        Boolean bl = this.kill;
                        synchronized (bl) {
                            if (this.kill.booleanValue()) {
                                return;
                            }
                        }
                    }
                    BoxAirDensityControlPanel.this.evacuateToggle = !BoxAirDensityControlPanel.this.evacuateToggle;
                    BoxAirDensityControlPanel.this.airButton.setText(BoxAirDensityControlPanel.this.evacuateToggle ? BoxAirDensityControlPanel.this.evacuateLabel : BoxAirDensityControlPanel.this.addLabel);
                    BoxAirDensityControlPanel.this.airButton.setEnabled(true);
                    BoxAirDensityControlPanel.this.airButton.setBackground(color);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }

            synchronized void kill() {
                this.kill = Boolean.TRUE;
                this.reset();
            }

            void reset() {
                BoxAirDensityControlPanel.this.evacuateToggle = true;
                BoxAirDensityControlPanel.this.airButton.setText(BoxAirDensityControlPanel.this.evacuateLabel);
                BoxAirDensityControlPanel.this.airButton.setEnabled(true);
                BoxAirDensityControlPanel.this.airButton.setBackground(BoxAirDensityControlPanel.this.airButtonEnabledBackground);
                BoxAirDensityControlPanel.this.setAirDensity(200.0, 200, BoxAirDensityControlPanel.this.attenuationFunction);
            }
        }
    }

    private static class AirBoxGraphic
    extends PhetShapeGraphic {
        static Color[] grayLevels = new Color[256];
        private int grayLevel;

        AirBoxGraphic(Component component, Shape shape) {
            super(component, shape, new Color(128, 128, 128), new BasicStroke(1.0f), new Color(138, 100, 70));
        }

        void setAirDensity(double d) {
            this.grayLevel = (int)(128.0 * d);
            this.setPaint(grayLevels[this.grayLevel]);
        }

        int getGrayLevel() {
            return this.grayLevel;
        }

        static {
            for (int i = 0; i < 256; ++i) {
                AirBoxGraphic.grayLevels[i] = new Color(i, i, i);
            }
        }
    }
}

