/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.common_sound.application.Module;
import edu.colorado.phet.common_sound.application.PhetApplication;
import edu.colorado.phet.common_sound.model.clock.AbstractClock;
import edu.colorado.phet.sound.SoundApplication;
import edu.colorado.phet.sound.model.Listener;
import edu.colorado.phet.sound.model.SineWaveFunction;
import edu.colorado.phet.sound.model.SoundClock;
import edu.colorado.phet.sound.model.SoundModel;
import edu.colorado.phet.sound.model.Wavefront;
import edu.colorado.phet.sound.view.RgbReporter;
import edu.colorado.phet.sound.view.WavefrontOscillator;
import java.awt.geom.Point2D;
import java.util.Random;

public class SoundModule
extends Module
implements RgbReporter {
    private static WavefrontOscillator primaryOscillator = new WavefrontOscillator();
    private static WavefrontOscillator octaveOscillator = new WavefrontOscillator();
    private Listener speakerListener;
    protected static final Random randomGenerator = new Random();
    private boolean audioEnabled = false;
    private Wavefront primaryWavefront;
    private Wavefront octaveWavefront;
    private Listener currentListener;
    private Boolean saveAudioEnabledState;
    private boolean isActive;
    private AbstractClock clock;

    public SoundModule(SoundApplication soundApplication, String string) {
        super(string);
        this.clock = soundApplication.getClock();
        this.setModel(new SoundModel(this.clock));
        this.initModel();
        this.speakerListener = new Listener((SoundModel)this.getModel(), new Point2D.Double());
        this.setListener(this.speakerListener);
        ((SoundClock)this.clock).addPauseListener(new SoundClock.PauseListener(){

            public void stateChanged(boolean bl) {
                if (SoundModule.this.isActive) {
                    if (bl) {
                        SoundModule.this.saveAudioEnabledState = new Boolean(SoundModule.this.audioEnabled);
                        primaryOscillator.setEnabled(false);
                        octaveOscillator.setEnabled(false);
                    } else {
                        SoundModule.this.setAudioEnabled(SoundModule.this.audioEnabled);
                        if (SoundModule.this.saveAudioEnabledState != null) {
                            SoundModule.this.setAudioEnabled(SoundModule.this.saveAudioEnabledState);
                        }
                        SoundModule.this.saveAudioEnabledState = null;
                    }
                } else if (SoundModule.this.saveAudioEnabledState != null) {
                    SoundModule.this.audioEnabled = SoundModule.this.saveAudioEnabledState;
                }
            }
        });
    }

    protected SoundModel getSoundModel() {
        return (SoundModel)this.getModel();
    }

    public void activate(PhetApplication phetApplication) {
        super.activate(phetApplication);
        if (!this.clock.isPaused()) {
            this.setAudioEnabled(this.audioEnabled);
        }
        if (this.currentListener != null) {
            this.setListener(this.currentListener);
        }
        this.isActive = true;
    }

    public void deactivate(PhetApplication phetApplication) {
        super.deactivate(phetApplication);
        this.isActive = false;
    }

    public void setAudioEnabled(boolean bl) {
        if (this.clock.isPaused()) {
            this.saveAudioEnabledState = new Boolean(bl);
        } else {
            this.audioEnabled = bl;
            primaryOscillator.setEnabled(bl);
            octaveOscillator.setEnabled(bl && this.getSoundModel().isOctaveEnabled());
        }
    }

    private void initModel() {
        this.primaryWavefront = new Wavefront();
        this.primaryWavefront.setWaveFunction(new SineWaveFunction(this.primaryWavefront));
        this.primaryWavefront.setEnabled(true);
        this.getSoundModel().addWaveFront(this.primaryWavefront);
        this.getSoundModel().setPrimaryWavefront(this.primaryWavefront);
        this.octaveWavefront = new Wavefront();
        this.octaveWavefront.setWaveFunction(new SineWaveFunction(this.octaveWavefront));
        this.octaveWavefront.setMaxAmplitude(0.0);
        this.octaveWavefront.setEnabled(false);
        this.getSoundModel().addWaveFront(this.octaveWavefront);
        this.getSoundModel().setOctaveWavefront(this.octaveWavefront);
        this.getSoundModel().setFrequency(500.0);
    }

    public void setAudioSource(int n) {
    }

    public WavefrontOscillator getPrimaryOscillator() {
        return primaryOscillator;
    }

    public WavefrontOscillator getOctaveOscillator() {
        return octaveOscillator;
    }

    public void setListener(Listener listener) {
        this.currentListener = listener;
        primaryOscillator.setListener(listener);
        octaveOscillator.setListener(listener);
    }

    public int rgbAt(int n, int n2) {
        return 128;
    }

    static {
        primaryOscillator.run();
        octaveOscillator.setHarmonicFactor(2.0);
    }
}

