/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_sound.application.PhetApplication;
import edu.colorado.phet.common_sound.view.help.HelpItem;
import edu.colorado.phet.common_sound.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common_sound.view.util.ImageLoader;
import edu.colorado.phet.sound.SoundApplication;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.SoundModule;
import edu.colorado.phet.sound.model.Listener;
import edu.colorado.phet.sound.model.SoundModel;
import edu.colorado.phet.sound.model.WaveMedium;
import edu.colorado.phet.sound.view.BufferedWaveMediumGraphic;
import edu.colorado.phet.sound.view.InteractiveSpeakerGraphic;
import edu.colorado.phet.sound.view.InterferenceListenerGraphic;
import edu.colorado.phet.sound.view.SoundApparatusPanel;
import edu.colorado.phet.sound.view.SpeakerGraphic;
import edu.colorado.phet.sound.view.TwoSourceInterferenceControlPanel;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TwoSpeakerInterferenceModule
extends SoundModule {
    private Listener speakerListener;
    private Listener headListener;
    private Point2D.Double audioSourceA;
    private Point2D.Double audioSourceB;
    private SoundModel soundModel = (SoundModel)this.getModel();
    private boolean saveInterferenceOverideEnabled = false;

    protected TwoSpeakerInterferenceModule(SoundApplication soundApplication) {
        super(soundApplication, SimStrings.get("ModuleTitle.TwoSpeakerIntererence"));
        this.speakerListener = new Listener((SoundModel)this.getModel(), new Point2D.Double());
        this.speakerListener.setLocation(new Point2D.Double());
        this.setListener(this.speakerListener);
        this.headListener = new Listener((SoundModel)this.getModel(), new Point2D.Double());
        this.setApparatusPanel(new SoundApparatusPanel(this.soundModel, soundApplication.getClock()));
        this.initApparatusPanel();
        this.initControlPanel();
    }

    private void initControlPanel() {
        this.setControlPanel(new TwoSourceInterferenceControlPanel(this));
    }

    private void initApparatusPanel() {
        this.audioSourceA = new Point2D.Double(SoundConfig.s_wavefrontBaseX, SoundConfig.s_wavefrontBaseY - 120);
        this.audioSourceB = new Point2D.Double(SoundConfig.s_wavefrontBaseX, SoundConfig.s_wavefrontBaseY + 120);
        WaveMedium waveMedium = this.getSoundModel().getWaveMedium();
        BufferedWaveMediumGraphic bufferedWaveMediumGraphic = new BufferedWaveMediumGraphic(waveMedium, this.getApparatusPanel());
        waveMedium.addObserver(bufferedWaveMediumGraphic);
        this.addGraphic(bufferedWaveMediumGraphic, 5.0);
        bufferedWaveMediumGraphic.initLayout(this.audioSourceA, SoundConfig.s_wavefrontHeight, SoundConfig.s_wavefrontRadius);
        bufferedWaveMediumGraphic.setOpacity(1.0f);
        SpeakerGraphic speakerGraphic = new SpeakerGraphic(this.getApparatusPanel(), waveMedium);
        speakerGraphic.setLocation(SoundConfig.s_speakerBaseX, (int)this.audioSourceA.getY());
        InteractiveSpeakerGraphic interactiveSpeakerGraphic = new InteractiveSpeakerGraphic(speakerGraphic, bufferedWaveMediumGraphic);
        interactiveSpeakerGraphic.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                InteractiveSpeakerGraphic interactiveSpeakerGraphic = (InteractiveSpeakerGraphic)changeEvent.getSource();
                TwoSpeakerInterferenceModule.this.audioSourceA.setLocation(interactiveSpeakerGraphic.getAudioSourceLocation());
            }
        });
        this.getApparatusPanel().addGraphic(interactiveSpeakerGraphic, 8.0);
        BufferedWaveMediumGraphic bufferedWaveMediumGraphic2 = new BufferedWaveMediumGraphic(waveMedium, this.getApparatusPanel());
        waveMedium.addObserver(bufferedWaveMediumGraphic2);
        this.addGraphic(bufferedWaveMediumGraphic2, 5.0);
        bufferedWaveMediumGraphic2.initLayout(this.audioSourceB, SoundConfig.s_wavefrontHeight, SoundConfig.s_wavefrontRadius);
        bufferedWaveMediumGraphic2.setOpacity(0.5f);
        SpeakerGraphic speakerGraphic2 = new SpeakerGraphic(this.getApparatusPanel(), waveMedium);
        this.getApparatusPanel().addGraphic(speakerGraphic2, 8.0);
        speakerGraphic2.setLocation(SoundConfig.s_speakerBaseX, (int)this.audioSourceB.getY());
        BufferedImage bufferedImage = null;
        try {
            int n = randomGenerator.nextInt(SoundConfig.HEAD_IMAGE_FILES.length);
            bufferedImage = ImageLoader.loadBufferedImage(SoundConfig.HEAD_IMAGE_FILES[n]);
            bufferedImage = ImageLoader.loadBufferedImage("sound/images/head-1-small.gif");
            PhetImageGraphic phetImageGraphic = new PhetImageGraphic(this.getApparatusPanel(), bufferedImage);
            phetImageGraphic.setLocation(SoundConfig.s_headBaseX, SoundConfig.s_headBaseY);
            InterferenceListenerGraphic interferenceListenerGraphic = new InterferenceListenerGraphic(this, this.headListener, phetImageGraphic, SoundConfig.s_headBaseX, SoundConfig.s_headBaseY, (double)SoundConfig.s_headBaseX - 150.0, (double)SoundConfig.s_headBaseY - 200.0, (double)SoundConfig.s_headBaseX + 150.0, (double)SoundConfig.s_headBaseY + 200.0, this.audioSourceA, this.audioSourceB, this.soundModel.getPrimaryWavefront(), interactiveSpeakerGraphic);
            this.addGraphic(interferenceListenerGraphic, 9.0);
            HelpItem helpItem = new HelpItem(this.getApparatusPanel(), SimStrings.get("TwoSpeakerInterferenceModule.Help1"), SoundConfig.s_headBaseX, SoundConfig.s_headBaseY - 20, 5, 1);
            helpItem.setForegroundColor(Color.white);
            this.addHelpItem(helpItem);
            HelpItem helpItem2 = new HelpItem(this.getApparatusPanel(), SimStrings.get("TwoSpeakerInterferenceModule.Help2"), SoundConfig.s_speakerBaseX, (int)this.audioSourceA.getY() - 120, 5, 1);
            helpItem2.setForegroundColor(Color.white);
            this.addHelpItem(helpItem2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setAudioSource(int n) {
        switch (n) {
            case 2: {
                this.setListener(this.headListener);
                this.getPrimaryOscillator().setInterferenceOverideEnabled(true);
                break;
            }
            case 1: {
                this.setListener(this.speakerListener);
                this.getPrimaryOscillator().setInterferenceOverideEnabled(false);
            }
        }
    }

    public void activate(PhetApplication phetApplication) {
        super.activate(phetApplication);
        this.getPrimaryOscillator().setInterferenceOverideEnabled(this.saveInterferenceOverideEnabled);
    }

    public void deactivate(PhetApplication phetApplication) {
        super.deactivate(phetApplication);
        this.saveInterferenceOverideEnabled = this.getPrimaryOscillator().getInterferenceOverideEnabled();
    }

    public int rgbAt(int n, int n2) {
        return super.rgbAt(n, n2) * 3 / 2;
    }
}

