/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_sound.model.clock.AbstractClock;
import edu.colorado.phet.sound.SingleSourceModule;
import edu.colorado.phet.sound.SoundApplication;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.model.SoundModel;
import edu.colorado.phet.sound.view.BufferedWaveMediumGraphic;
import edu.colorado.phet.sound.view.ReflectingWallGraphic;
import edu.colorado.phet.sound.view.SoundControlPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WallInterferenceModule
extends SingleSourceModule {
    private static double s_wallOffsetX = 170.0;
    private static double s_wallOffsetY = 300.0;
    private static double s_wallThickness = 650.0;
    private static double s_wallHeight = 6.0;
    private static double s_initialWallAngle = 60.0;
    private SoundModel soundModel;
    private ReflectingWallGraphic wallGraphic;
    private double wallAngle = s_initialWallAngle;
    private BufferedWaveMediumGraphic interferringWavefrontGraphic;
    private Point2D.Double p;
    private Point2D.Double pp;
    private AbstractClock clock;

    public WallInterferenceModule(SoundApplication soundApplication) {
        super(soundApplication, SimStrings.get("ModuleTitle.WallInterference"));
        this.soundModel = (SoundModel)this.getModel();
        this.clock = soundApplication.getClock();
        this.wallGraphic = new ReflectingWallGraphic(this.getApparatusPanel(), Color.blue, (double)SoundConfig.s_wavefrontBaseX + s_wallOffsetX, (double)SoundConfig.s_wavefrontBaseY + s_wallOffsetY, s_wallThickness, s_wallHeight, s_initialWallAngle);
        this.addGraphic(this.wallGraphic, 8.0);
        this.interferringWavefrontGraphic = new BufferedWaveMediumGraphic(this.soundModel.getWaveMedium(), this.getApparatusPanel());
        this.addGraphic(this.interferringWavefrontGraphic, 7.0);
        this.positionInterferingWavefront();
        WallTiltControlPanel wallTiltControlPanel = new WallTiltControlPanel();
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(wallTiltControlPanel);
        jPanel.add(new WallTranslateControlPanel());
        ((SoundControlPanel)this.getControlPanel()).addPanel(jPanel);
        ((SoundControlPanel)this.getControlPanel()).setAmplitude(1.0);
        ((SoundControlPanel)this.getControlPanel()).addPanel(new PulsePanel());
        this.getApparatusPanel().invalidate();
        this.getApparatusPanel().repaint();
    }

    private void positionInterferingWavefront() {
        this.p = new Point2D.Double(SoundConfig.s_wavefrontBaseX, SoundConfig.s_wavefrontBaseY);
        Point2D point2D = MathUtil.reflectPointAcrossLine(this.p, new Point2D.Double(this.wallGraphic.getMidPoint().getX(), this.wallGraphic.getMidPoint().getY()), Math.toRadians(-this.wallAngle));
        this.pp = (Point2D.Double)point2D;
        this.interferringWavefrontGraphic.clear();
        this.interferringWavefrontGraphic.initLayout(new Point2D.Double(this.pp.getX(), this.pp.getY()), SoundConfig.s_wavefrontHeight, SoundConfig.s_wavefrontRadius, this.wallAngle * 2.0);
        this.interferringWavefrontGraphic.setOpacity(0.5f);
    }

    public void setWallAngle(float f) {
        this.wallAngle = f;
        this.wallGraphic.setAngle(this.wallAngle);
        this.positionInterferingWavefront();
    }

    public void setWallLocation(float f) {
        this.wallGraphic.setLocation((float)SoundConfig.s_wavefrontBaseX + f);
        this.positionInterferingWavefront();
    }

    static /* synthetic */ AbstractClock access$900(WallInterferenceModule wallInterferenceModule) {
        return wallInterferenceModule.clock;
    }

    private class PulsePanel
    extends JPanel {
        private JButton pulseBtn;
        private Double savedAmplitude;

        public PulsePanel() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), SimStrings.get("WallInterferenceMode.modeCtrlTitle")));
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton(SimStrings.get("WallInterferenceMode.continuous"));
            JRadioButton jRadioButton2 = new JRadioButton(SimStrings.get("WallInterferenceMode.pulse"));
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), SimStrings.get("WallInterferenceMode.modeTitle")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 20, 0, 20);
            jPanel.add((Component)jRadioButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            jPanel.add((Component)jRadioButton2, gridBagConstraints);
            this.pulseBtn = new JButton(SimStrings.get("WallInterferenceMode.fire"));
            this.pulseBtn.addActionListener(new ActionListener(this){
                private final /* synthetic */ PulsePanel this$1;
                {
                    this.this$1 = pulsePanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PulsePanel.access$400(this.this$1);
                }
            });
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.pulseBtn, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            this.add((Component)jPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            this.add((Component)this.pulseBtn, gridBagConstraints);
            jRadioButton.addActionListener(new ActionListener(this, jRadioButton){
                private final /* synthetic */ JRadioButton val$continuousModeBtn;
                private final /* synthetic */ PulsePanel this$1;
                {
                    this.this$1 = pulsePanel;
                    this.val$continuousModeBtn = jRadioButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$continuousModeBtn.isSelected()) {
                        PulsePanel.access$500(this.this$1, false);
                    }
                }
            });
            jRadioButton2.addActionListener(new ActionListener(this, jRadioButton2){
                private final /* synthetic */ JRadioButton val$pulseModeBtn;
                private final /* synthetic */ PulsePanel this$1;
                {
                    this.this$1 = pulsePanel;
                    this.val$pulseModeBtn = jRadioButton;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.val$pulseModeBtn.isSelected()) {
                        PulsePanel.access$500(this.this$1, true);
                    }
                }
            });
            this.setPulseMode(false);
            jRadioButton.setSelected(true);
        }

        private void setPulseMode(boolean bl) {
            this.pulseBtn.setEnabled(bl);
            if (bl) {
                this.savedAmplitude = new Double(WallInterferenceModule.this.soundModel.getPrimaryWavefront().getMaxAmplitude());
                WallInterferenceModule.this.soundModel.getPrimaryWavefront().clear();
                WallInterferenceModule.this.soundModel.getPrimaryWavefront().setMaxAmplitude(0.0);
            } else if (this.savedAmplitude != null) {
                WallInterferenceModule.this.soundModel.getPrimaryWavefront().setMaxAmplitude(this.savedAmplitude);
            }
        }

        private void producePulse() {
            Runnable runnable = new Runnable(this){
                private final /* synthetic */ PulsePanel this$1;
                {
                    this.this$1 = pulsePanel;
                }

                public void run() {
                    WallInterferenceModule.access$600(PulsePanel.access$800(this.this$1)).getPrimaryWavefront().setMaxAmplitude(PulsePanel.access$700(this.this$1));
                    double d = WallInterferenceModule.access$900(PulsePanel.access$800(this.this$1)).getRunningTime();
                    double d2 = 6.0 / WallInterferenceModule.access$600(PulsePanel.access$800(this.this$1)).getPrimaryWavefront().getFrequency();
                    WallInterferenceModule.access$600(PulsePanel.access$800(this.this$1)).getPrimaryWavefront().getAmplitude();
                    while (WallInterferenceModule.access$900(PulsePanel.access$800(this.this$1)).getRunningTime() - d < d2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    WallInterferenceModule.access$600(PulsePanel.access$800(this.this$1)).getPrimaryWavefront().setMaxAmplitude(0.0);
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }

        static /* synthetic */ void access$400(PulsePanel pulsePanel) {
            pulsePanel.producePulse();
        }

        static /* synthetic */ void access$500(PulsePanel pulsePanel, boolean bl) {
            pulsePanel.setPulseMode(bl);
        }

        static /* synthetic */ Double access$700(PulsePanel pulsePanel) {
            return pulsePanel.savedAmplitude;
        }

        static /* synthetic */ WallInterferenceModule access$800(PulsePanel pulsePanel) {
            return pulsePanel.WallInterferenceModule.this;
        }
    }

    public class WallTranslateControlPanel
    extends JPanel {
        WallTranslateControlPanel() {
            this.setLayout(new GridLayout(1, 1));
            this.setPreferredSize(new Dimension(125, 70));
            JSlider jSlider = new JSlider(0, 0, 400, (int)s_wallOffsetX);
            jSlider.setPreferredSize(new Dimension(25, 100));
            jSlider.setPaintTicks(true);
            jSlider.setMajorTickSpacing(50);
            jSlider.setMinorTickSpacing(25);
            jSlider.addChangeListener(new ChangeListener(this, jSlider){
                private final /* synthetic */ JSlider val$wallTranslationSlider;
                private final /* synthetic */ WallTranslateControlPanel this$1;
                {
                    this.this$1 = wallTranslateControlPanel;
                    this.val$wallTranslationSlider = jSlider;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    WallTranslateControlPanel.access$300(this.this$1).setWallLocation(this.val$wallTranslationSlider.getValue());
                }
            });
            this.add(jSlider);
            TitledBorder titledBorder = new TitledBorder(SimStrings.get("WallInterferenceModule.Position"));
            this.setBorder(titledBorder);
        }

        static /* synthetic */ WallInterferenceModule access$300(WallTranslateControlPanel wallTranslateControlPanel) {
            return wallTranslateControlPanel.WallInterferenceModule.this;
        }
    }

    public class WallTiltControlPanel
    extends JPanel {
        WallTiltControlPanel() {
            this.setLayout(new GridLayout(1, 1));
            this.setPreferredSize(new Dimension(125, 100));
            JSlider jSlider = new JSlider(1, 10, 90, (int)s_initialWallAngle);
            jSlider.setPreferredSize(new Dimension(25, 100));
            jSlider.setPaintTicks(true);
            jSlider.setMajorTickSpacing(20);
            jSlider.setMinorTickSpacing(10);
            jSlider.addChangeListener(new ChangeListener(this, WallInterferenceModule.this, jSlider){
                private final /* synthetic */ WallInterferenceModule val$this$0;
                private final /* synthetic */ JSlider val$wallAngleSlider;
                private final /* synthetic */ WallTiltControlPanel this$1;
                {
                    this.this$1 = wallTiltControlPanel;
                    this.val$this$0 = wallInterferenceModule;
                    this.val$wallAngleSlider = jSlider;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    WallTiltControlPanel.access$100(this.this$1).setWallAngle(this.val$wallAngleSlider.getValue());
                }
            });
            this.add(jSlider);
            TitledBorder titledBorder = new TitledBorder(SimStrings.get("WallInterferenceModule.Angle"));
            this.setBorder(titledBorder);
        }

        static /* synthetic */ WallInterferenceModule access$100(WallTiltControlPanel wallTiltControlPanel) {
            return wallTiltControlPanel.WallInterferenceModule.this;
        }
    }
}

