/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.model;

import edu.colorado.phet.common_sound.model.ModelElement;
import edu.colorado.phet.common_sound.util.SimpleObservable;
import edu.colorado.phet.sound.model.SoundModel;
import java.awt.geom.Point2D;

public class Listener
extends SimpleObservable
implements ModelElement {
    private Point2D.Double location = new Point2D.Double();
    private Point2D.Double origin;
    private SoundModel model;
    private double frequencyHeard;
    private double amplitudeHeard;
    private double octaveAmplitudeHeard;

    public Listener(SoundModel soundModel, Point2D.Double double_) {
        this.model = soundModel;
        soundModel.addModelElement(this);
        this.origin = double_;
    }

    public Point2D.Double getLocation() {
        return this.location;
    }

    public void setLocation(Point2D.Double double_) {
        this.location.setLocation(double_);
        this.notifyObservers();
    }

    public void stepInTime(double d) {
        int n = (int)this.location.distance(this.origin);
        double d2 = this.model.getPrimaryWavefront().getFrequencyAtTime(n);
        double d3 = this.model.getPrimaryWavefront().getMaxAmplitudeAtTime(n);
        double d4 = this.model.getOctaveWavefront().getMaxAmplitudeAtTime(n);
        boolean bl = false;
        if (d2 != this.frequencyHeard || d3 != this.amplitudeHeard || d4 != this.octaveAmplitudeHeard) {
            bl = true;
        }
        this.frequencyHeard = d2;
        this.amplitudeHeard = d3;
        this.octaveAmplitudeHeard = d4;
        if (bl) {
            this.notifyObservers();
        }
    }

    public double getFrequencyHeard() {
        return this.frequencyHeard;
    }

    public double getAmplitudeHeard() {
        return this.amplitudeHeard;
    }
}

