/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.model;

import edu.colorado.phet.common_sound.model.BaseModel;
import edu.colorado.phet.common_sound.model.clock.AbstractClock;
import edu.colorado.phet.sound.model.WaveMedium;
import edu.colorado.phet.sound.model.Wavefront;
import java.util.Iterator;

public class SoundModel
extends BaseModel {
    private WaveMedium waveMedium = new WaveMedium();
    private AbstractClock clock;
    private Wavefront primaryWavefront;
    private Wavefront octaveWavefront;
    private boolean octaveEnabled = false;

    public SoundModel(AbstractClock abstractClock) {
        this.clock = abstractClock;
        this.setWaveMedium(this.waveMedium);
    }

    public WaveMedium getWaveMedium() {
        return this.waveMedium;
    }

    public void setWaveMedium(WaveMedium waveMedium) {
        if (this.waveMedium != null) {
            this.removeModelElement(this.waveMedium);
        }
        this.waveMedium = waveMedium;
        this.addModelElement(waveMedium);
    }

    public void addWaveFront(Wavefront wavefront) {
        this.waveMedium.addWavefront(wavefront);
        this.setPropagationSpeed(3);
    }

    public void setPropagationSpeed(int n) {
        Iterator iterator = this.waveMedium.getWavefronts().iterator();
        while (iterator.hasNext()) {
            Wavefront wavefront = (Wavefront)iterator.next();
            wavefront.setPropagationSpeed(n);
        }
    }

    public void setFrequency(double d) {
        this.primaryWavefront.setFrequency(d / 4000.0);
        this.octaveWavefront.setFrequency(2.0 * d / 4000.0);
    }

    public double getAmplitude() {
        return this.primaryWavefront.getMaxAmplitude();
    }

    public void setAmplitude(double d) {
        this.primaryWavefront.setMaxAmplitude(d);
    }

    public void setOctaveWavefront(Wavefront wavefront) {
        this.octaveWavefront = wavefront;
    }

    public Wavefront getPrimaryWavefront() {
        return this.primaryWavefront;
    }

    public Wavefront getOctaveWavefront() {
        return this.octaveWavefront;
    }

    public void setPrimaryWavefront(Wavefront wavefront) {
        this.primaryWavefront = wavefront;
    }

    public boolean isOctaveEnabled() {
        return this.octaveEnabled;
    }
}

