/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.model;

import edu.colorado.phet.common_sound.model.ModelElement;
import edu.colorado.phet.common_sound.util.SimpleObservable;
import edu.colorado.phet.sound.model.AttenuationFunction;
import edu.colorado.phet.sound.model.Wavefront;
import java.util.ArrayList;

public class WaveMedium
extends SimpleObservable
implements ModelElement {
    private ArrayList wavefronts = new ArrayList();
    private AttenuationFunction attenuationFunction = new AttenuationFunction(){

        public double getAttenuation(double d, double d2) {
            return 1.0;
        }
    };

    public void stepInTime(double d) {
        for (int i = 0; i < this.wavefronts.size(); ++i) {
            Wavefront wavefront = (Wavefront)this.wavefronts.get(i);
            wavefront.stepInTime(d, this.attenuationFunction);
        }
        this.notifyObservers();
    }

    public int getMaxX() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.wavefronts.size(); ++i) {
            Wavefront wavefront = (Wavefront)this.wavefronts.get(i);
            n = Math.min(n, wavefront.getAmplitude().length);
        }
        return n;
    }

    public void addWavefront(Wavefront wavefront) {
        this.wavefronts.add(wavefront);
    }

    public ArrayList getWavefronts() {
        return this.wavefronts;
    }

    public double getAmplitudeAt(double d) {
        double d2 = 0.0;
        int n = 0;
        for (int i = 0; i < this.wavefronts.size(); ++i) {
            Wavefront wavefront = (Wavefront)this.wavefronts.get(i);
            if (!wavefront.isEnabled()) continue;
            ++n;
            d2 += wavefront.getAmplitude()[(int)d];
        }
        return d2 /= (double)n;
    }

    public void setAttenuationFunction(AttenuationFunction attenuationFunction) {
        this.attenuationFunction = attenuationFunction;
    }
}

