/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.sound.SoundModule;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class AudioControlPanel
extends JPanel {
    private JCheckBox audioOnOffCB;
    private JRadioButton speakerRB;
    private JRadioButton listenerRB;
    private SoundModule module;

    public AudioControlPanel(final SoundModule soundModule) {
        this.module = soundModule;
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(125, 100));
        JPanel jPanel = new JPanel();
        this.audioOnOffCB = new JCheckBox(SimStrings.get("AudioControlPanel.Enabled"));
        jPanel.add(this.audioOnOffCB);
        this.audioOnOffCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                soundModule.setAudioEnabled(AudioControlPanel.this.audioOnOffCB.isSelected());
            }
        });
        this.add(this.audioOnOffCB);
        soundModule.setAudioEnabled(this.audioOnOffCB.isSelected());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.speakerRB = new JRadioButton(SimStrings.get("AudioControlPanel.Speaker"));
        this.listenerRB = new JRadioButton(SimStrings.get("AudioControlPanel.Listener"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.speakerRB);
        buttonGroup.add(this.listenerRB);
        jPanel2.add(this.speakerRB);
        jPanel2.add(this.listenerRB);
        this.add(jPanel2);
        this.speakerRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AudioControlPanel.this.speakerRB.isSelected() ? 1 : 2;
                soundModule.setAudioSource(n);
            }
        });
        this.listenerRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = AudioControlPanel.this.listenerRB.isSelected() ? 2 : 1;
                soundModule.setAudioSource(n);
            }
        });
        this.setBorder(new TitledBorder(SimStrings.get("AudioControlPanel.BorderTitle")));
        this.speakerRB.setSelected(true);
    }

    public void setAudioSource(int n) {
        this.listenerRB.setSelected(n == 2);
        this.speakerRB.setSelected(n == 1);
        this.module.setAudioSource(n);
    }
}

