/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_sound.model.BaseModel;
import edu.colorado.phet.common_sound.model.ModelElement;
import edu.colorado.phet.common_sound.util.EventChannel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ClockPanelLarge
extends JPanel {
    private JTextField clockTF = new JTextField();
    private NumberFormat clockFormat = new DecimalFormat("0.0000");
    private String[] startStopStr;
    private EventChannel eventRegistry = new EventChannel(ClockPanelListener.class);
    private ClockPanelListener clockPanelListenerProxy = (ClockPanelListener)this.eventRegistry.getListenerProxy();
    private JButton resetBtn;
    private ModelElement modelTickCounter;
    private BaseModel model;
    private double runningTime = 0.0;
    private int startStopState = 0;
    private JButton startStopBtn;

    public ClockPanelLarge(BaseModel baseModel) {
        this.model = baseModel;
        this.setBackground(new Color(237, 225, 113));
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.clockTF = new JTextField(5);
        Font font = this.clockTF.getFont();
        this.clockTF.setFont(new Font(font.getName(), 1, 16));
        this.clockTF.setEditable(false);
        this.clockTF.setHorizontalAlignment(4);
        this.clockTF.setText(this.clockFormat.format(0L));
        this.runningTime = 0.0;
        this.modelTickCounter = new ModelElement(){

            public void stepInTime(double d) {
                ClockPanelLarge.this.runningTime = d + ClockPanelLarge.this.runningTime;
                ClockPanelLarge.this.clockTF.setText(ClockPanelLarge.this.clockFormat.format(ClockPanelLarge.this.runningTime * 4.0338846308995566E-5));
            }
        };
        this.startStopStr = new String[2];
        this.startStopStr[0] = "Start";
        this.startStopStr[1] = "Stop";
        this.startStopBtn = new JButton(this.startStopStr[0]);
        this.startStopBtn.addActionListener(new StartStopActionListener());
        this.resetBtn = new JButton("Reset");
        this.resetBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClockPanelLarge.this.resetClock();
            }
        });
        this.setLayout(new GridBagLayout());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Insets insets = new Insets(5, 5, 5, 5);
        GridBagConstraints gridBagConstraints = null;
        gridBagConstraints = new GridBagConstraints(0, n, 2, 1, 1.0, 1.0, 10, 0, insets, n2, n3);
        this.add((Component)new JLabel(SimStrings.get("ClockPanelLarge.SimulationTime")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 13, 0, insets, n2, n3);
        this.add((Component)this.clockTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 17, 0, insets, n2, n3);
        this.add((Component)new JLabel(SimStrings.get("ClockPanelLarge.Seconds")), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 0, insets, n2, n3);
        ++n;
        gridBagConstraints.gridy = n++;
        this.add((Component)this.startStopBtn, gridBagConstraints);
        gridBagConstraints.gridy = n;
        this.add((Component)this.resetBtn, gridBagConstraints);
    }

    private void resetClock() {
        this.model.removeModelElement(this.modelTickCounter);
        this.runningTime = 0.0;
        this.modelTickCounter.stepInTime(0.0);
        ClockPanelEvent clockPanelEvent = new ClockPanelEvent(this);
        clockPanelEvent.setReset(true);
        clockPanelEvent.setRunning(false);
        this.clockPanelListenerProxy.clockPaneEventOccurred(clockPanelEvent);
    }

    public void addListener(ClockPanelListener clockPanelListener) {
        this.eventRegistry.addListener(clockPanelListener);
    }

    public class ClockPanelEvent
    extends EventObject {
        boolean isRunning;
        boolean isReset;

        public ClockPanelEvent(Object object) {
            super(object);
            this.isRunning = true;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void setRunning(boolean bl) {
            this.isRunning = bl;
        }

        public boolean isReset() {
            return this.isReset;
        }

        public void setReset(boolean bl) {
            this.isReset = bl;
        }
    }

    public static interface ClockPanelListener
    extends EventListener {
        public void clockPaneEventOccurred(ClockPanelEvent var1);
    }

    private class StartStopActionListener
    implements ActionListener {
        private StartStopActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.toggle();
        }

        private void toggle() {
            if (ClockPanelLarge.this.startStopState == 0) {
                ClockPanelLarge.this.model.addModelElement(ClockPanelLarge.this.modelTickCounter);
                ClockPanelEvent clockPanelEvent = new ClockPanelEvent(this);
                clockPanelEvent.setRunning(true);
                ClockPanelLarge.this.clockPanelListenerProxy.clockPaneEventOccurred(clockPanelEvent);
                ClockPanelLarge.this.resetBtn.setEnabled(false);
            } else {
                ClockPanelLarge.this.model.removeModelElement(ClockPanelLarge.this.modelTickCounter);
                ClockPanelEvent clockPanelEvent = new ClockPanelEvent(this);
                clockPanelEvent.setRunning(false);
                ClockPanelLarge.this.clockPanelListenerProxy.clockPaneEventOccurred(clockPanelEvent);
                ClockPanelLarge.this.resetBtn.setEnabled(true);
            }
            ClockPanelLarge.this.startStopState = (ClockPanelLarge.this.startStopState + 1) % 2;
            ClockPanelLarge.this.startStopBtn.setText(ClockPanelLarge.this.startStopStr[ClockPanelLarge.this.startStopState]);
        }
    }
}

