/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common_sound.util.EventChannel;
import edu.colorado.phet.common_sound.view.graphics.mousecontrols.TranslationEvent;
import edu.colorado.phet.common_sound.view.graphics.mousecontrols.TranslationListener;
import edu.colorado.phet.common_sound.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.view.BufferedWaveMediumGraphic;
import edu.colorado.phet.sound.view.SpeakerGraphic;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InteractiveSpeakerGraphic
extends CompositePhetGraphic {
    private SpeakerGraphic speakerGraphic;
    private BufferedWaveMediumGraphic waveMediumGraphic;
    private ArrayList mouseReleaseListeners = new ArrayList();
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public InteractiveSpeakerGraphic(SpeakerGraphic speakerGraphic, BufferedWaveMediumGraphic bufferedWaveMediumGraphic) {
        this.speakerGraphic = speakerGraphic;
        this.addGraphic(speakerGraphic);
        this.waveMediumGraphic = bufferedWaveMediumGraphic;
        this.setCursorHand();
        this.addTranslationListener(new SpeakerTranslator());
    }

    public Point2D.Double getAudioSourceLocation() {
        return new Point2D.Double(this.waveMediumGraphic.getOrigin().getX(), this.waveMediumGraphic.getOrigin().getY());
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    private class SpeakerTranslator
    implements TranslationListener {
        private SpeakerTranslator() {
        }

        public void translationOccurred(TranslationEvent translationEvent) {
            Point point = InteractiveSpeakerGraphic.this.speakerGraphic.getLocation();
            InteractiveSpeakerGraphic.this.speakerGraphic.setLocation((int)((Point2D)point).getX(), (int)(((Point2D)point).getY() + (double)(2 * MathUtil.getSign(translationEvent.getDy()))));
            InteractiveSpeakerGraphic.this.waveMediumGraphic.setOrigin(new Point2D.Double(SoundConfig.s_wavefrontBaseX, ((InteractiveSpeakerGraphic)InteractiveSpeakerGraphic.this).speakerGraphic.getLocation().y));
            InteractiveSpeakerGraphic.this.changeListenerProxy.stateChanged(new ChangeEvent(InteractiveSpeakerGraphic.this));
        }
    }
}

