/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common_sound.view.graphics.mousecontrols.TranslationEvent;
import edu.colorado.phet.common_sound.view.graphics.mousecontrols.TranslationListener;
import edu.colorado.phet.common_sound.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.sound.TwoSpeakerInterferenceModule;
import edu.colorado.phet.sound.model.Listener;
import edu.colorado.phet.sound.model.SoundModel;
import edu.colorado.phet.sound.model.Wavefront;
import edu.colorado.phet.sound.view.InteractiveSpeakerGraphic;
import edu.colorado.phet.sound.view.ListenerGraphic;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class InterferenceListenerGraphic
extends ListenerGraphic {
    private Point2D.Double audioSourceA;
    private Point2D.Double audioSourceB;
    private Wavefront interferringWavefront;
    private Point2D.Double earLocation = new Point2D.Double();
    private TwoSpeakerInterferenceModule soundModule;
    private SoundModel soundModel;

    public InterferenceListenerGraphic(TwoSpeakerInterferenceModule twoSpeakerInterferenceModule, Listener listener, PhetImageGraphic phetImageGraphic, double d, double d2, double d3, double d4, double d5, double d6, Point2D.Double double_, Point2D.Double double_2, Wavefront wavefront, InteractiveSpeakerGraphic interactiveSpeakerGraphic) {
        super(twoSpeakerInterferenceModule, listener, phetImageGraphic, d, d2, d3, d4, d5, d6);
        this.soundModule = twoSpeakerInterferenceModule;
        this.soundModel = (SoundModel)twoSpeakerInterferenceModule.getModel();
        this.audioSourceA = double_;
        this.audioSourceB = double_2;
        this.interferringWavefront = wavefront;
        this.addTranslationListener(new TranslationListener(){

            public void translationOccurred(TranslationEvent translationEvent) {
                InterferenceListenerGraphic.this.updateAmplitude();
            }
        });
        interactiveSpeakerGraphic.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                InterferenceListenerGraphic.this.updateAmplitude();
            }
        });
        this.updateAmplitude();
    }

    public void paint(Graphics2D graphics2D) {
        super.paint(graphics2D);
    }

    private synchronized void updateAmplitude() {
        this.earLocation.setLocation(this.getLocation().getX() + (double)s_earOffsetX, this.getLocation().getY() + (double)s_earOffsetY);
        double d = (float)this.earLocation.distance(this.audioSourceA);
        double d2 = (float)this.earLocation.distance(this.audioSourceB);
        double d3 = this.interferringWavefront.getWavelengthAtTime(0);
        double d4 = (d - d2) / d3 * Math.PI;
        double d5 = this.soundModel.getAmplitude();
        double d6 = d5 * Math.abs(Math.cos(d4));
        this.soundModule.getPrimaryOscillator().setAmplitude(d6);
    }
}

