/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common_sound.view.graphics.mousecontrols.TranslationEvent;
import edu.colorado.phet.common_sound.view.graphics.mousecontrols.TranslationListener;
import edu.colorado.phet.common_sound.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_sound.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.SoundModule;
import edu.colorado.phet.sound.model.Listener;
import edu.colorado.phet.sound.model.SoundModel;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.LinkedList;

public class ListenerGraphic
extends CompositePhetGraphic {
    protected static int s_earOffsetX = 10;
    protected static int s_earOffsetY = 53;
    private float s_dopplerShiftScaleFactor = 10.0f;
    private Listener listener;
    private SoundModel model;
    private Point2D.Double location;
    private PhetImageGraphic image;
    private SoundModule module;
    private Point2D.Double earLocation = new Point2D.Double();
    private boolean isMovable = true;
    private int numSamples = 5;
    private LinkedList samples = new LinkedList();

    public ListenerGraphic(SoundModule soundModule, Listener listener, PhetImageGraphic phetImageGraphic, double d, double d2, double d3, double d4, double d5, double d6) {
        super(soundModule.getApparatusPanel());
        this.addGraphic(phetImageGraphic);
        this.location = new Point2D.Double(d, d2);
        this.module = soundModule;
        this.model = (SoundModel)soundModule.getModel();
        this.image = phetImageGraphic;
        this.listener = listener;
        this.setCursorHand();
        ListenerTranslationBehavior listenerTranslationBehavior = new ListenerTranslationBehavior(d3, d4, d5, d6);
        this.addTranslationListener(listenerTranslationBehavior);
        listenerTranslationBehavior.translate(0.0, 0.0);
    }

    public void setMovable(boolean bl) {
        this.isMovable = bl;
        if (bl) {
            this.setCursorHand();
        } else {
            this.removeCursor();
        }
    }

    public Point getLocation() {
        return new Point((int)this.location.getX(), (int)this.location.getY());
    }

    private class ListenerTranslationBehavior
    implements TranslationListener {
        private double minX;
        private double minY;
        private double maxX;
        private double maxY;

        ListenerTranslationBehavior(double d, double d2, double d3, double d4) {
            this.minX = d;
            this.minY = d2;
            this.maxX = d3;
            this.maxY = d4;
        }

        public void translationOccurred(TranslationEvent translationEvent) {
            this.translate(translationEvent.getDx(), translationEvent.getDy());
        }

        public void translate(double d, double d2) {
            if (ListenerGraphic.this.isMovable) {
                double d3 = Math.max(this.minX, Math.min(this.maxX, ListenerGraphic.this.location.getX() + d));
                double d4 = Math.max(this.minY, Math.min(this.maxY, ListenerGraphic.this.location.getY() + d2));
                ListenerGraphic.this.location.setLocation(d3, d4);
                ListenerGraphic.this.image.setLocation((int)d3, (int)d4);
                ListenerGraphic.this.earLocation.setLocation(ListenerGraphic.this.getLocation().getX() + (double)s_earOffsetX, ListenerGraphic.this.getLocation().getY() + (double)s_earOffsetY);
                ListenerGraphic.this.listener.setLocation(new Point2D.Double(((ListenerGraphic)ListenerGraphic.this).earLocation.x - (double)(SoundConfig.s_wavefrontBaseX + 100), ((ListenerGraphic)ListenerGraphic.this).earLocation.y - (double)SoundConfig.s_wavefrontBaseY));
            }
        }
    }
}

