/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common_sound.model.clock.AbstractClock;
import edu.colorado.phet.common_sound.util.SimpleObserver;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.model.SoundModel;
import edu.colorado.phet.sound.model.WaveMedium;
import edu.colorado.phet.sound.view.SoundApparatusPanel;
import edu.colorado.phet.sound.view.SpeakerGraphic;

public class SingleSourceApparatusPanel
extends SoundApparatusPanel {
    private SpeakerGraphic speakerGraphic;

    public SingleSourceApparatusPanel(SoundModel soundModel, AbstractClock abstractClock) {
        super(soundModel, abstractClock);
        this.setBackground(SoundConfig.MIDDLE_GRAY);
        final WaveMedium waveMedium = soundModel.getWaveMedium();
        this.speakerGraphic = new SpeakerGraphic(this, waveMedium);
        this.addGraphic(this.speakerGraphic, 8.0);
        waveMedium.addObserver(new SimpleObserver(){
            private int s_maxSpeakerConeExcursion = 6;

            public void update() {
                int n = (int)(waveMedium.getAmplitudeAt(0.0) / 1.0 * (double)this.s_maxSpeakerConeExcursion);
                SingleSourceApparatusPanel.this.speakerGraphic.setConePosition(n);
            }
        });
    }
}

