/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.view.util.SimStrings;
import edu.colorado.phet.common_sound.application.Module;
import edu.colorado.phet.common_sound.view.ControlPanel;
import edu.colorado.phet.sound.model.SoundModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SoundControlPanel
extends ControlPanel {
    private MyControlPanel soundControlPanel;
    private int rowIdx = 0;
    private AmplitudeControlPanel amplitudeControlPanel;

    public SoundControlPanel(Module module) {
        super(module);
        this.soundControlPanel = new MyControlPanel(module);
        this.addControl(this.soundControlPanel);
    }

    public void addPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, this.rowIdx++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.soundControlPanel.add((Component)jPanel, gridBagConstraints);
    }

    public void setAmplitude(double d) {
        this.amplitudeControlPanel.setAmplitude(d);
    }

    private static class AmplitudeControlPanel
    extends JPanel {
        private JSlider amplitudeSlider;
        private int sliderMax = 10;
        private int sliderMin = 0;
        private int sliderDefault = 5;
        private SoundModel model;

        AmplitudeControlPanel(SoundModel soundModel) {
            this.model = soundModel;
            this.setLayout(new GridLayout(1, 2));
            this.setPreferredSize(new Dimension(125, 60));
            this.amplitudeSlider = new JSlider(0, this.sliderMin, this.sliderMax, this.sliderDefault);
            this.amplitudeSlider.setPreferredSize(new Dimension(25, 100));
            this.amplitudeSlider.setPaintTicks(true);
            this.amplitudeSlider.setMajorTickSpacing(5);
            this.amplitudeSlider.setMinorTickSpacing(1);
            this.amplitudeSlider.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AmplitudeControlPanel this$0;
                {
                    this.this$0 = amplitudeControlPanel;
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }
            });
            this.amplitudeSlider.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ AmplitudeControlPanel this$0;
                {
                    this.this$0 = amplitudeControlPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    AmplitudeControlPanel.access$700(this.this$0, AmplitudeControlPanel.access$600(this.this$0).getValue());
                }
            });
            this.setModelAmplitude(this.amplitudeSlider.getValue());
            this.add(this.amplitudeSlider);
            TitledBorder titledBorder = new TitledBorder(SimStrings.get("SoundControlPanel.Amplitude"));
            this.setBorder(titledBorder);
        }

        private void setModelAmplitude(int n) {
            double d = (double)n * 1.0 / (double)(this.sliderMax - this.sliderMin);
            this.model.setAmplitude(d);
        }

        public void setAmplitude(double d) {
            int n = (int)((double)(this.sliderMax - this.sliderMin) * d + (double)this.sliderMin);
            this.amplitudeSlider.setValue(n);
            this.setModelAmplitude(n);
        }

        static /* synthetic */ JSlider access$600(AmplitudeControlPanel amplitudeControlPanel) {
            return amplitudeControlPanel.amplitudeSlider;
        }

        static /* synthetic */ void access$700(AmplitudeControlPanel amplitudeControlPanel, int n) {
            amplitudeControlPanel.setModelAmplitude(n);
        }
    }

    private static class FrequencyControlPanel
    extends JPanel {
        private JTextField frequencyTF;
        private JSlider frequencySlider;
        private String Hertz = SimStrings.get("SoundControlPanel.Hertz");

        FrequencyControlPanel(SoundModel soundModel) {
            this.setLayout(new GridLayout(2, 1));
            this.setPreferredSize(new Dimension(125, 80));
            JPanel jPanel = new JPanel(new BorderLayout());
            this.frequencyTF = new JTextField(4);
            this.frequencyTF.setEditable(false);
            this.frequencyTF.setHorizontalAlignment(4);
            Font font = this.frequencyTF.getFont();
            this.frequencyTF.setFont(new Font(font.getName(), 1, 12));
            this.frequencyTF.setText(Integer.toString(500) + " " + this.Hertz);
            this.frequencySlider = new JSlider(0, 0, 1000, 500);
            this.frequencySlider.setPreferredSize(new Dimension(20, 60));
            this.frequencySlider.setPaintTicks(true);
            this.frequencySlider.setMajorTickSpacing(100);
            this.frequencySlider.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ FrequencyControlPanel this$0;
                {
                    this.this$0 = frequencyControlPanel;
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }
            });
            this.frequencySlider.addChangeListener(new ChangeListener(this, soundModel){
                private final /* synthetic */ SoundModel val$model;
                private final /* synthetic */ FrequencyControlPanel this$0;
                {
                    this.this$0 = frequencyControlPanel;
                    this.val$model = soundModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    FrequencyControlPanel.access$300(this.this$0, this.val$model, FrequencyControlPanel.access$200(this.this$0).getValue());
                    FrequencyControlPanel.access$500(this.this$0).setText(Integer.toString(FrequencyControlPanel.access$200(this.this$0).getValue()) + " " + FrequencyControlPanel.access$400(this.this$0));
                }
            });
            this.updateFrequency(soundModel, this.frequencySlider.getValue());
            jPanel.add((Component)this.frequencyTF, "Center");
            this.add(jPanel);
            this.add(this.frequencySlider);
            TitledBorder titledBorder = new TitledBorder(SimStrings.get("SoundControlPanel.BorderTitle"));
            this.setBorder(titledBorder);
        }

        private void updateFrequency(SoundModel soundModel, int n) {
            this.frequencyTF.setText(Integer.toString(n) + " " + this.Hertz);
            soundModel.setFrequency(n);
        }

        static /* synthetic */ JSlider access$200(FrequencyControlPanel frequencyControlPanel) {
            return frequencyControlPanel.frequencySlider;
        }

        static /* synthetic */ void access$300(FrequencyControlPanel frequencyControlPanel, SoundModel soundModel, int n) {
            frequencyControlPanel.updateFrequency(soundModel, n);
        }

        static /* synthetic */ String access$400(FrequencyControlPanel frequencyControlPanel) {
            return frequencyControlPanel.Hertz;
        }

        static /* synthetic */ JTextField access$500(FrequencyControlPanel frequencyControlPanel) {
            return frequencyControlPanel.frequencyTF;
        }
    }

    private class MyControlPanel
    extends JPanel {
        MyControlPanel(Module module) {
            this.setLayout(new GridBagLayout());
            if (!(module.getModel() instanceof SoundModel)) {
                throw new RuntimeException("Type of parameter is invalid");
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, SoundControlPanel.this.rowIdx++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)new FrequencyControlPanel((SoundModel)module.getModel()), gridBagConstraints);
            gridBagConstraints.gridy = SoundControlPanel.this.rowIdx++;
            SoundControlPanel.this.amplitudeControlPanel = new AmplitudeControlPanel((SoundModel)module.getModel());
            this.add((Component)SoundControlPanel.this.amplitudeControlPanel, gridBagConstraints);
        }
    }
}

