/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common_sound.util.SimpleObserver;
import edu.colorado.phet.common_sound.view.ApparatusPanel;
import edu.colorado.phet.common_sound.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common_sound.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.common_sound.view.util.ImageLoader;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.model.WaveMedium;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class SpeakerGraphic
extends CompositePhetGraphic {
    public static int s_speakerConeOffsetX = 34;
    private PhetImageGraphic speakerFrame;
    private PhetImageGraphic speakerCone;
    private BufferedImage speakerFrameImg;
    private BufferedImage speakerConeImg;
    private Point2D.Double location = new Point2D.Double();

    public SpeakerGraphic(ApparatusPanel apparatusPanel, final WaveMedium waveMedium) {
        super(apparatusPanel);
        try {
            this.speakerFrameImg = ImageLoader.loadBufferedImage("sound/images/speaker-frame.gif");
            this.speakerConeImg = ImageLoader.loadBufferedImage("sound/images/speaker-cone.gif");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Image files not found");
        }
        this.speakerFrame = new PhetImageGraphic(apparatusPanel, this.speakerFrameImg);
        this.speakerCone = new PhetImageGraphic(apparatusPanel, this.speakerConeImg);
        this.setLocation(SoundConfig.s_speakerBaseX, SoundConfig.s_wavefrontBaseY);
        this.addGraphic(this.speakerFrame);
        this.addGraphic(this.speakerCone);
        waveMedium.addObserver(new SimpleObserver(){
            private int s_maxSpeakerConeExcursion = 6;

            public void update() {
                int n = (int)(waveMedium.getAmplitudeAt(0.0) / 1.0 * (double)this.s_maxSpeakerConeExcursion);
                SpeakerGraphic.this.speakerCone.setLocation((int)SpeakerGraphic.this.location.getX() + s_speakerConeOffsetX + n, (int)SpeakerGraphic.this.location.getY() - SpeakerGraphic.this.speakerConeImg.getHeight(null) / 2);
            }
        });
    }

    public void setLocation(int n, int n2) {
        this.location.setLocation(n, n2);
        this.speakerFrame.setLocation(n, n2 - this.speakerFrameImg.getHeight(null) / 2);
        this.speakerCone.setLocation(n + s_speakerConeOffsetX, n2 - this.speakerConeImg.getHeight(null) / 2);
    }

    public Point getLocation() {
        return new Point((int)this.location.getX(), (int)this.location.getY());
    }

    protected void syncBounds() {
        super.syncBounds();
    }

    public void setConePosition(int n) {
        this.speakerCone.setLocation((int)this.location.getX() + s_speakerConeOffsetX + n, (int)this.location.getY() - this.speakerConeImg.getHeight(null) / 2);
    }
}

