/*
 * Decompiled with CFR 0.152.
 */
package jass.generators;

import jass.engine.Out;

public class LoopBuffer
extends Out {
    protected float[] loopBuffer;
    protected int loopBufferLength;
    protected float volume = 1.0f;
    protected float speed = 1.0f;
    protected float x = 0.0f;
    protected int ix = 0;
    protected float dx;
    protected int dix;
    public float srate;
    private float srateRatio = 1.0f;
    public float srateLoopBuffer;
    private String name = "x";

    public LoopBuffer(float f, int n, float[] fArray) {
        super(n);
        this.loopBuffer = fArray;
        this.srateLoopBuffer = this.srate = f;
        this.loopBufferLength = fArray.length;
        this.setSpeed(this.speed);
    }

    public void setVolume(float f) {
        this.volume = f;
    }

    public void setSpeed(float f) {
        this.speed = f;
        float f2 = f * this.srateRatio;
        this.dix = (int)f2;
        this.dx = f2 - (float)this.dix;
    }

    protected float getNextSample() {
        this.ix += this.dix;
        this.x += this.dx;
        if (this.x > 1.0f) {
            this.x -= 1.0f;
            ++this.ix;
        }
        while (this.ix >= this.loopBufferLength) {
            this.ix -= this.loopBufferLength;
        }
        int n = this.ix == this.loopBufferLength - 1 ? 0 : this.ix + 1;
        float f = (1.0f - this.dx) * this.loopBuffer[this.ix] + this.dx * this.loopBuffer[n];
        return f * this.volume;
    }

    public void computeBuffer() {
        int n = this.getBufferSize();
        for (int i = 0; i < n; ++i) {
            this.buf[i] = this.getNextSample();
        }
    }
}

