/*
 * Decompiled with CFR 0.152.
 */
package jass.render;

import jass.render.FormatUtils;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class RTPlay
extends Thread {
    private float srate;
    private int bitsPerFrame;
    private int nchannels;
    private boolean signed;
    private AudioFormat audioFormat;
    private SourceDataLine sourceDataLine;
    private Mixer mixer;
    private int scratchBufsz;
    private byte[] bbuf;
    private String preferredMixer = null;
    private boolean useNative = false;
    private long nativeObjectPointer = 0L;

    public native long initNativeSound(int var1, int var2, int var3, int var4);

    public native void writeNativeSoundFloat(long var1, float[] var3, int var4);

    public native void closeNativeSound(long var1);

    private void findMixer() {
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        int n = 0;
        if (this.preferredMixer != null) {
            for (int i = 0; i < infoArray.length; ++i) {
                System.out.println("mixer " + i + "-----------------\n");
                String string = infoArray[i].getName();
                System.out.println("name:" + string);
                if (!string.equalsIgnoreCase(this.preferredMixer)) continue;
                n = i;
            }
        }
        System.out.println("CHOSEN MIXER: " + infoArray[n].getName());
        this.mixer = AudioSystem.getMixer(infoArray[n]);
    }

    private void initAudio(int n, float f, int n2, int n3, boolean bl) {
        this.srate = f;
        this.bitsPerFrame = n2;
        this.nchannels = n3;
        this.signed = bl;
        this.findMixer();
        this.audioFormat = new AudioFormat(f, n2, n3, bl, false);
        DataLine.Info info = n == 0 ? new DataLine.Info(SourceDataLine.class, this.audioFormat) : new DataLine.Info(SourceDataLine.class, this.audioFormat, n);
        if (!this.mixer.isLineSupported(info)) {
            System.out.println(this.getClass().getName() + " : Error: sourcedataline: not supported (this may be a bogus message under Tritonus)\n");
        }
        try {
            this.sourceDataLine = (SourceDataLine)this.mixer.getLine(info);
            if (n == 0) {
                this.sourceDataLine.open(this.audioFormat);
            } else {
                this.sourceDataLine.open(this.audioFormat, n);
            }
            this.sourceDataLine.start();
        }
        catch (LineUnavailableException lineUnavailableException) {
            System.out.println(this.getClass().getName() + " : Error getting line\n");
        }
        this.scratchBufsz = 4;
        this.bbuf = new byte[this.scratchBufsz];
    }

    private void initAudioNative(float f, int n, int n2, int n3) {
        this.srate = f;
        this.bitsPerFrame = this.bitsPerFrame;
        this.nchannels = n;
        this.signed = this.signed;
        this.scratchBufsz = 8;
        this.nativeObjectPointer = this.initNativeSound(n, (int)f, n2, n3);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                System.out.println("The shutdown hook in RTPlay is executing");
                RTPlay.this.close();
                try {
                    1.sleep(100L);
                }
                catch (Exception exception) {
                    System.out.print("The sleep function is broken");
                }
            }
        });
    }

    public RTPlay(int n, float f, int n2, int n3, boolean bl, String string) {
        this.preferredMixer = string;
        this.initAudio(n, f, n2, n3, bl);
    }

    public RTPlay(float f, int n, int n2, int n3) {
        this.useNative = true;
        try {
            System.loadLibrary("rtaudio");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("Could not load shared library rtaudio: " + unsatisfiedLinkError);
        }
        this.initAudioNative(f, n, n2, n3);
    }

    public void write(float[] fArray) {
        if (this.useNative) {
            this.writeNativeSoundFloat(this.nativeObjectPointer, fArray, fArray.length);
        } else {
            if (2 * fArray.length > this.scratchBufsz) {
                this.scratchBufsz = 2 * fArray.length;
                this.bbuf = new byte[this.scratchBufsz];
            }
            FormatUtils.floatToByte(this.bbuf, fArray);
            this.sourceDataLine.write(this.bbuf, 0, 2 * fArray.length);
        }
    }

    public void close() {
        if (this.useNative) {
            System.out.println("RTPlay.close() will call closeNativeSound: nativeObjectPointer= " + this.nativeObjectPointer);
            if (this.nativeObjectPointer != 0L) {
                this.closeNativeSound(this.nativeObjectPointer);
                this.nativeObjectPointer = 0L;
            }
            try {
                RTPlay.sleep(100L);
            }
            catch (Exception exception) {}
        } else {
            this.sourceDataLine.stop();
            this.sourceDataLine.close();
        }
    }
}

