/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class AdvancedPanel
extends VerticalLayoutPanel {
    private JButton advanced;
    private JButton hideButton;
    private VerticalLayoutPanel controls;
    private boolean expanded = false;
    ArrayList listeners = new ArrayList();

    public AdvancedPanel() {
        this("Advanced >>", "Hide <<");
    }

    public AdvancedPanel(String string, String string2) {
        this.controls = new VerticalLayoutPanel();
        this.controls.setFillNone();
        this.advanced = new JButton(string);
        this.advanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanel.this.showAdvanced();
            }
        });
        this.hideButton = new JButton(string2);
        this.hideButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPanel.this.hideAdvanced();
            }
        });
        this.setFill(0);
        this.add(this.advanced);
    }

    public void addControlFullWidth(JComponent jComponent) {
        this.controls.addFullWidth(jComponent);
    }

    protected void showAdvanced() {
        if (!this.isExpanded()) {
            this.expanded = true;
            this.remove(this.advanced);
            this.add(this.hideButton);
            this.add(this.controls);
            this.validateAll();
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.advancedPanelShown(this);
            }
        }
    }

    private void validateAll() {
        this.invalidate();
        this.controls.invalidate();
        if (this.getParent() != null) {
            this.getParent().invalidate();
            if (this.getParent().getParent() != null) {
                this.getParent().getParent().invalidate();
                this.getParent().getParent().validate();
            }
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        window.invalidate();
        window.validate();
        window.repaint();
    }

    protected void hideAdvanced() {
        if (this.isExpanded()) {
            this.expanded = false;
            this.remove(this.hideButton);
            this.remove(this.controls);
            this.add(this.advanced);
            this.validateAll();
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener listener = (Listener)this.listeners.get(i);
                listener.advancedPanelHidden(this);
            }
            this.setBorder(null);
        }
    }

    private boolean isExpanded() {
        return this.expanded;
    }

    public static interface Listener {
        public void advancedPanelHidden(AdvancedPanel var1);

        public void advancedPanelShown(AdvancedPanel var1);
    }
}

